/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.smtp.smtp;

import de.lwsystems.mailarchive.bennoimport.core.auth.IRequestService;
import de.lwsystems.mailarchive.bennoimport.core.auth.RequestService;
import de.lwsystems.mailarchive.bennoimport.core.auth.RestCall;
import de.lwsystems.mailarchive.bennoimport.core.client.HttpClientFactory;
import de.lwsystems.mailarchive.bennoimport.core.client.RestHttpClientFactory;
import de.lwsystems.mailarchive.bennoimport.core.config.yaml.httpclient.HttpClient;
import de.lwsystems.mailarchive.bennoimport.core.services.ICalculateChecksum;
import de.lwsystems.mailarchive.bennoimport.core.services.IMailCreator;
import de.lwsystems.mailarchive.bennoimport.core.services.ITempFileHandling;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.IJournalMailHandlingService;
import de.lwsystems.mailarchive.bennoimport.core.ssl.TrustAllTrustManager;
import de.lwsystems.mailarchive.bennoimport.core.utils.BennoRestSslUtils;
import de.lwsystems.mailarchive.bennoimport.smtp.config.Benno;
import de.lwsystems.mailarchive.bennoimport.smtp.config.smtp.SMTP;
import de.lwsystems.mailarchive.bennoimport.smtp.config.smtp.Server;
import de.lwsystems.mailarchive.bennoimport.smtp.config.smtp.SslKeyStore;
import de.lwsystems.mailarchive.bennoimport.smtp.listeners.BennoMessageHandlerFactory;
import de.lwsystems.mailarchive.bennoimport.smtp.listeners.BennoMessageListener;
import de.lwsystems.mailarchive.bennoimport.smtp.request.MailUploader;
import de.lwsystems.mailarchive.bennoimport.smtp.validators.BennoUsernamePasswordUsernamePasswordValidator;
import de.lwsystems.mailarchive.bennoimport.smtp.validators.IBasicAuthUsernamePasswordValidator;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.concurrent.Executors;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.subethamail.smtp.AuthenticationHandlerFactory;
import org.subethamail.smtp.MessageHandlerFactory;
import org.subethamail.smtp.auth.EasyAuthenticationHandlerFactory;
import org.subethamail.smtp.auth.UsernamePasswordValidator;
import org.subethamail.smtp.server.SMTPServer;

public class SMTPMailServer {
    private static final Logger LOGGER = LogManager.getLogger(SMTPMailServer.class);

    private SMTPMailServer() {
    }

    public static SSLContext createTlsSslContext(KeyManager[] keyManagers, TrustManager[] trustManagers) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, trustManagers, new SecureRandom());
        LOGGER.debug("TLS SSL context created");
        return sslContext;
    }

    public static TrustManager[] getTrustManagers(X509TrustManager trustManager) {
        return new TrustManager[]{trustManager};
    }

    public static KeyManager[] createKeyManagerArray(KeyStore keyStore, String password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keyStore, password.toCharArray());
        LOGGER.debug("Create key manager array for SMTP server");
        return kmf.getKeyManagers();
    }

    public static SSLContext createSslContext(SMTP smtpConfig) {
        try {
            if (smtpConfig.getServer().getSslKeyStore() == null) {
                LOGGER.warn("No SSL keystore configured");
                return null;
            }
            KeyStore keystore = SMTPMailServer.buildKeystore(smtpConfig.getServer().getSslKeyStore());
            LOGGER.debug("Creating SSL context for SMTP server");
            return SMTPMailServer.createTlsSslContext(SMTPMailServer.createKeyManagerArray(keystore, smtpConfig.getServer().getSslKeyStore().getSslKeyStorePass()), SMTPMailServer.getTrustManagers((X509TrustManager)new TrustAllTrustManager()));
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            LOGGER.error("Failed to create SSL context", (Throwable)ex);
            return null;
        }
    }

    public static KeyStore buildKeystore(SslKeyStore sslKeyStoreConfig) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        LOGGER.debug("Create keystore for SMTP server");
        return BennoRestSslUtils.createJksKeystore((String)sslKeyStoreConfig.getSslCertPath(), (String)sslKeyStoreConfig.getSslPrivateKeyPath(), (String)sslKeyStoreConfig.getSslKeyStorePass(), (String)"benno-import-smtp");
    }

    public static SMTPServer createServer(ITempFileHandling tempFileHandling, IMailCreator mailCreator, ICalculateChecksum calculateChecksum, HttpClient httpClientConfig, Benno bennoConfig, IJournalMailHandlingService journalMailHandlingService) {
        BennoUsernamePasswordUsernamePasswordValidator validator = new BennoUsernamePasswordUsernamePasswordValidator();
        MailUploader mailUploader = new MailUploader((IRequestService)new RequestService(new RestCall((HttpClientFactory)new RestHttpClientFactory(), httpClientConfig)));
        BennoMessageListener listener = new BennoMessageListener(validator, mailUploader, bennoConfig, bennoConfig.getRestEndpoint().getJwt(), tempFileHandling, calculateChecksum, mailCreator, journalMailHandlingService);
        BennoMessageHandlerFactory messageHandlerFactory = new BennoMessageHandlerFactory(listener);
        Server smtpServerConfig = bennoConfig.getSmtp().getServer();
        SMTPServer.Builder serverBuilder = SMTPMailServer.createBaseServerBuilder(smtpServerConfig, messageHandlerFactory, validator);
        if (smtpServerConfig.isTls()) {
            SSLContext sslContext = SMTPMailServer.createSslContext(bennoConfig.getSmtp());
            if (sslContext == null) {
                LOGGER.error("TLS is required but no SSL context was created");
                throw new IllegalStateException("TLS is required but no SSL context was created");
            }
            serverBuilder.startTlsSocketFactory(sslContext);
        }
        smtpServerConfig.getBindAddress().ifPresent(arg_0 -> ((SMTPServer.Builder)serverBuilder).bindAddress(arg_0));
        return serverBuilder.build();
    }

    public static SMTPServer.Builder createBaseServerBuilder(Server smtpServerConfig, MessageHandlerFactory messageHandlerFactory, IBasicAuthUsernamePasswordValidator validator) {
        return SMTPServer.port((int)smtpServerConfig.getPort()).hostName(smtpServerConfig.getHostname()).messageHandlerFactory(messageHandlerFactory).maxConnections(smtpServerConfig.getMaxConnections()).maxMessageSize(smtpServerConfig.getMaxMessageSize()).maxRecipients(smtpServerConfig.getMaxRecipients()).requireAuth(smtpServerConfig.isAuth()).requireTLS(smtpServerConfig.isTls()).executorService(Executors.newFixedThreadPool(smtpServerConfig.getThreads())).authenticationHandlerFactory((AuthenticationHandlerFactory)new EasyAuthenticationHandlerFactory((UsernamePasswordValidator)validator));
    }
}

