/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.smtp.validators;

import de.lwsystems.mailarchive.bennoimport.core.utils.BennoHeaderUtils;
import de.lwsystems.mailarchive.bennoimport.smtp.validators.IBasicAuthUsernamePasswordValidator;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.subethamail.smtp.MessageContext;
import org.subethamail.smtp.auth.LoginFailedException;

public class BennoUsernamePasswordUsernamePasswordValidator
implements IBasicAuthUsernamePasswordValidator {
    private String basicAuthString;
    private static final Logger LOGGER = LogManager.getLogger(BennoUsernamePasswordUsernamePasswordValidator.class);

    @Override
    public String getBasicAuthString() {
        return this.basicAuthString;
    }

    public void login(String username, String password, MessageContext context) throws LoginFailedException {
        Objects.requireNonNull(password, "Password cannot be null");
        Objects.requireNonNull(username, "Username cannot be null");
        try {
            if (username.isEmpty() || password.isEmpty()) {
                throw new LoginFailedException("Username or password is empty");
            }
            this.basicAuthString = BennoHeaderUtils.createBasicAuthString((String)username, (String)password);
        }
        catch (LoginFailedException ex) {
            LOGGER.error(ex.getMessage());
            throw new LoginFailedException(ex.getMessage());
        }
    }
}

