#!/bin/sh
# postinst script for benno-import-tools
#
# see: dh_installdeb(1)

set -e

# summary of how this script can be called:
#        * <postinst> `configure' <most-recently-configured-version>
#        * <old-postinst> `abort-upgrade' <new version>
#        * <conflictor's-postinst> `abort-remove' `in-favour' <package>
#          <new-version>
#        * <postinst> `abort-remove'
#        * <deconfigured's-postinst> `abort-deconfigure' `in-favour'
#          <failed-install-package> <version> `removing'
#          <conflicting-package> <version>
# for details, see http://www.debian.org/doc/debian-policy/ or
# the debian-policy package


case "$1" in
    configure)
        chmod 0755 /etc/benno-import-tools
        chown benno /etc/benno-import-tools
        chgrp benno /etc/benno-import-tools/benno-import.conf
        chgrp benno /etc/benno-import-tools/send2rest.whitelist
        chgrp www-data /etc/benno-import-tools/rest_auth.conf
        chmod 0640 /etc/benno-import-tools/benno-import.conf
        chmod 0640 /etc/benno-import-tools/send2rest.whitelist
        chmod 0640 /etc/benno-import-tools/rest_auth.conf

        chown benno:benno /srv/benno/inbox
        chmod 0750 /srv/benno/inbox
    ;;

    abort-upgrade|abort-remove|abort-deconfigure)
    ;;

    *)
        echo "postinst called with unknown argument \`$1'" >&2
        exit 1
    ;;
esac

# dh_installdeb will replace this with shell code automatically
# generated by other debhelper scripts.



exit 0
