/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.rest.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.lwsystems.mailarchive.archive.box.MailDocumentId;
import de.lwsystems.mailarchive.rest.api.BennoMailApi;
import de.lwsystems.mailarchive.rest.api.BennoSearchApi;
import de.lwsystems.mailarchive.rest.api.MailResult;
import de.lwsystems.mailarchive.rest.api.SearchAnswer;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.codec.binary.Base64;

public class BennoClient
implements BennoMailApi,
BennoSearchApi {
    private final String endpoint;
    private final String username;
    private final String password;

    public BennoClient(String endpoint, String username, String password) {
        this.endpoint = endpoint;
        this.username = username;
        this.password = password;
    }

    @Override
    public MailResult getMail(String archive, MailDocumentId documentId) {
        return null;
    }

    @Override
    public SearchAnswer search(String searchArchive, String queryString, String filterQuery, int limitRequestParameter, String sortField, boolean full, boolean sortAsc, int start, String scidSearch) {
        try {
            URL url = new URL(this.endpoint + "/search/?query=" + queryString + "&filterQuery=" + filterQuery + "&archive=" + searchArchive);
            byte[] auth = (this.username + ":" + this.password).getBytes("UTF-8");
            String encoding = Base64.encodeBase64String((byte[])auth);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setRequestProperty("Authorization", "Basic " + encoding);
            InputStream content = connection.getInputStream();
            return (SearchAnswer)new ObjectMapper().readValue(content, SearchAnswer.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

