/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.rest.utils;

import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.MailDocumentId;
import de.lwsystems.mailarchive.config.FSBoxStorageConfig;
import de.lwsystems.mailarchive.utils.CompressionUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;

public class RepoMailTools {
    public static Path getRepoMailPath(MailDocumentId mailDocumentId, IBox bennoBox) {
        IBox.CompressionType compression = bennoBox.getBoxConfig().getCompression();
        StringBuilder initializationMailPath = new StringBuilder();
        initializationMailPath.append(bennoBox.getRepoPath()).append("/").append(bennoBox.getIdentifier());
        FSBoxStorageConfig sysBoxStorageConfig = (FSBoxStorageConfig)bennoBox.getBoxConfig().getBoxStorageConfig();
        int separatorIndex = mailDocumentId.toString().indexOf(":");
        String instanceIdMailChecksum = mailDocumentId.toString().substring(separatorIndex + 1);
        for (int i = 0; i < sysBoxStorageConfig.getDirLength() * sysBoxStorageConfig.getSubdirs(); i += sysBoxStorageConfig.getDirLength()) {
            initializationMailPath.append("/").append(instanceIdMailChecksum.substring(0, sysBoxStorageConfig.getDirLength()));
            instanceIdMailChecksum = instanceIdMailChecksum.substring(sysBoxStorageConfig.getDirLength(), instanceIdMailChecksum.length());
        }
        initializationMailPath.append("/").append(instanceIdMailChecksum).append(CompressionUtil.getCompressionSuffix((IBox.CompressionType)compression));
        return Paths.get(initializationMailPath.toString(), new String[0]);
    }

    public static FileTime getCreationTime(MailDocumentId mailDocumentId, IBox bennoBox) throws IOException {
        Path repoFilePath = RepoMailTools.getRepoMailPath(mailDocumentId, bennoBox);
        if (Files.exists(repoFilePath, new LinkOption[0])) {
            return Files.readAttributes(repoFilePath, BasicFileAttributes.class, new LinkOption[0]).creationTime();
        }
        return null;
    }

    public static FileTime getLastModfiedDate(MailDocumentId mailDocumentId, IBox bennoBox) throws IOException {
        Path repoFilePath = RepoMailTools.getRepoMailPath(mailDocumentId, bennoBox);
        if (Files.exists(repoFilePath, new LinkOption[0])) {
            return Files.readAttributes(repoFilePath, BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime();
        }
        return null;
    }
}

