/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.search.lucene;

import de.lwsystems.mailarchive.search.IStatsHit;
import de.proite.mailarchive.rest.tools.RecipientResolver;
import org.apache.lucene.document.Document;

public class LuceneStatsHit
implements IStatsHit {
    private Document hitDoc;
    private RecipientResolver rr;

    public LuceneStatsHit(Document hitDoc) {
        this.hitDoc = hitDoc;
        this.rr = new RecipientResolver(hitDoc.getFieldables("To"), hitDoc.getFieldables("Cc"), hitDoc.getFieldables("Recipient"));
    }

    public String getSubject() {
        return this.hitDoc.get("Subject");
    }

    @Override
    public String getSender() {
        return this.hitDoc.get("Sender");
    }

    @Override
    public String getFrom() {
        return this.hitDoc.get("From");
    }

    @Override
    public String[] getTo() {
        return this.rr.getToArray();
    }

    @Override
    public String[] getCc() {
        return this.rr.getCcArray();
    }

    @Override
    public String getScid() {
        return this.hitDoc.get("scid");
    }

    @Override
    public Long getSize() {
        return Long.parseLong(this.hitDoc.get("Size"));
    }

    @Override
    public Integer getMailCount() {
        return 0;
    }

    @Override
    public Integer getMailAccounts() {
        return 1;
    }
}

