/*
 * Decompiled with CFR 0.152.
 */
package de.proite.mailarchive.rest.tools;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.MimeUtility;

public class DecodeHeader {
    private static final String ENCODED_PART_REGEX_PATTERN = "=\\?([^?]+)\\?([^?]+)\\?([^?]+)\\?=";
    private static final String CONTROL_CHARACTERS = "[\\u0000-\\u001f]";

    public static String decode(String s) {
        Pattern pattern = Pattern.compile(ENCODED_PART_REGEX_PATTERN);
        Matcher m = pattern.matcher(s);
        ArrayList<String> encodedParts = new ArrayList<String>();
        while (m.find()) {
            encodedParts.add(m.group(0));
        }
        if (encodedParts.size() > 0) {
            try {
                for (String encoded : encodedParts) {
                    s = s.replace(encoded, MimeUtility.decodeWord((String)encoded));
                }
                return s.replaceAll(CONTROL_CHARACTERS, "");
            }
            catch (Exception ex) {
                return s;
            }
        }
        return s;
    }
}

