#! /bin/sh
### BEGIN INIT INFO
# Provides:          benno-rest
# Required-Start:    $local_fs $remote_fs
# Required-Stop:     $local_fs $remote_fs
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: Starts the REST interface of Benno Mailarchiv
# Description:       This file should be used to construct scripts to be
#                    placed in /etc/init.d.
### END INIT INFO

# Author: Martin Werthmoeller <mw@lw-systems.de>

# Do NOT "set -e"

# PATH should only include /usr/* if it runs after the mountnfs.sh script
PATH=/sbin:/usr/sbin:/bin:/usr/bin
DESC="REST interface for Benno Mailarchive"
NAME="benno-rest"
DAEMON=/usr/bin/java
JAR_FILE="bennorest.jar"
START_JAR="-jar $JAR_FILE"
PIDFILE=/var/run/$NAME.pid
SCRIPTNAME=/etc/init.d/$NAME
BENNOCOREDIR=/opt/benno
LOG_CONFIG=/etc/benno/bennorest-log4j.xml

# Exit if the package is not installed
[ -f "$BENNOCOREDIR/$JAR_FILE" ] || exit 0

LANG=C; export LANG

# check java version
JAVA7=/usr/lib/jvm/java-7-openjdk-amd64/jre/bin/java
[ -x $JAVA7 ] && DAEMON=$JAVA7
JAVA8=/usr/lib/jvm/java-8-openjdk-amd64/jre/bin/java
[ -x $JAVA8 ] && DAEMON=$JAVA8

# Read configuration variable file if it is present
[ -r /etc/default/$NAME ] && . /etc/default/$NAME

if [ "$START_ARCHIVE"x != "yes"x ]; then
                echo "$NAME disabled: not starting. To enable it edit /etc/default/$NAME"
                exit 0
fi

# Load the VERBOSE setting and other rcS variables
. /lib/init/vars.sh

# Define LSB log_* functions.
# Depend on lsb-base (>= 3.0-6) to ensure that this file is present.
. /lib/lsb/init-functions

#
# Function that starts the daemon/service
#
do_start()
{
    ulimit -n 8192
	echo "Starting Benno REST interface ..."
	start-stop-daemon -b --start --chdir $BENNOCOREDIR --chuid $USER \
        --make-pidfile --pidfile $PIDFILE \
        --umask 027 --exec $DAEMON -- \
        -Dlog4j.configuration=$LOG_CONFIG \
        $JAVA_OPTIONS \
        $START_JAR \
        $DAEMON_ARGS \
		|| return 2
}

#
# Function that stops the daemon/service
#
do_stop()
{
	# Return
	#   0 if daemon has been stopped
	#   1 if daemon was already stopped
	#   2 if daemon could not be stopped
	#   other if a failure occurred
	start-stop-daemon --stop --quiet --oknodo --pidfile $PIDFILE
	RETVAL="$?"
	rm -f $PIDFILE
	return "$RETVAL"
}

#
# Function that sends a SIGHUP to the daemon/service
#
do_reload() {
	start-stop-daemon --stop --signal 1 --quiet --pidfile $PIDFILE
	return 0
}

#
# Function that prints system info
#
do_info()
{
    (
        cd $BENNOCOREDIR
        su  -s /bin/sh \
            -c "$DAEMON \
                -Dlog4j.configuration=file://$LOG_CONFIG \
                $JAVA_OPTIONS \
                $START_JAR \
                $DAEMON_ARGS \
                --host-info" \
            $USER
    )
}




case "$1" in
  start)
	[ "$VERBOSE" != no ] && log_daemon_msg "Starting $DESC" "$NAME"
	do_start
	case "$?" in
		0|1) [ "$VERBOSE" != no ] && log_end_msg 0 ;;
		2) [ "$VERBOSE" != no ] && log_end_msg 1 ;;
	esac
	;;
  stop)
	[ "$VERBOSE" != no ] && log_daemon_msg "Stopping $DESC" "$NAME"
	do_stop
	case "$?" in
		0|1) [ "$VERBOSE" != no ] && log_end_msg 0 ;;
		2) [ "$VERBOSE" != no ] && log_end_msg 1 ;;
	esac
	;;
  reload)
	log_daemon_msg "Reloading $DESC" "$NAME"
	do_reload
	log_end_msg $?
	;;
  restart|force-reload)
	log_daemon_msg "Restarting $DESC" "$NAME"
	do_stop
	case "$?" in
	  0|1)
		do_start
		case "$?" in
			0) log_end_msg 0 ;;
			1) log_end_msg 1 ;; # Old process is still running
			*) log_end_msg 1 ;; # Failed to start
		esac
		;;
	  *)
	  	# Failed to stop
		log_end_msg 1
		;;
	esac
	;;
  status)
	status_of_proc -p ${PIDFILE} /opt/benno/bennoarchive.jar benno-archive && exit 0 || exit $?
	;;
  info)
     do_info
    ;; 
  *)
	echo "Usage: $SCRIPTNAME {start|stop|restart|reload|force-reload}" >&2
	exit 3
	;;
esac

:
