/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.s3tool.Benno.Box;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.ArchiveNotFoundException;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.container.ContainerNotFoundException;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.utils.ContainerTools;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BennoBoxes {
    protected final Benno benno;
    private Map<IContainer, List<IBox>> containerBoxMap = new HashMap<IContainer, List<IBox>>();

    protected BennoBoxes(Benno benno) {
        this.benno = benno;
        this.setBoxes();
    }

    protected BennoBoxes(Benno benno, String container) throws ArchiveNotFoundException, ContainerNotFoundException {
        this.benno = benno;
        this.setBoxes(container);
    }

    private void setBoxes() {
        this.benno.getArchives().forEach(this::getContainers);
    }

    private void setBoxes(String container) throws ContainerNotFoundException, ArchiveNotFoundException {
        try {
            IContainer bennoContainer = ContainerTools.getContainer((String)container, (Benno)this.benno);
            this.setContainerBoxMap(bennoContainer.getArchive().getContainerGenerator().getContainer(container));
        }
        catch (ContainerNotFoundException e) {
            throw new ContainerNotFoundException(container);
        }
        catch (ArchiveNotFoundException e) {
            throw new ArchiveNotFoundException(container);
        }
    }

    public Map<IContainer, List<IBox>> getContainerBoxMap() {
        return this.containerBoxMap;
    }

    private void getContainers(IArchive archive) {
        archive.getContainerGenerator().getContainers().forEach(this::setContainerBoxMap);
    }

    public abstract void setContainerBoxMap(IContainer var1);
}

