/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.s3tool.Benno.Encryption;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.IBoxHolder;
import de.lwsystems.mailarchive.config.BoxEncryption;
import de.lwsystems.mailarchive.config.ConfigurationException;
import de.lwsystems.mailarchive.s3tool.Benno.Box.BennoBoxReader;
import de.lwsystems.mailarchive.s3tool.Output.Output;
import de.lwsystems.mailarchive.utils.CryptoUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;

public class Encryption {
    private KeyPair keyPair;
    private BoxEncryption boxEncryption;

    public BoxEncryption getBoxEncryption() {
        return this.boxEncryption;
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public Encryption(IBox iBox) throws ArchiveException {
        this.boxEncryption = new BennoBoxReader(iBox, false).getBoxEncryption();
        this.configureEncryption(iBox.getBoxHolder());
    }

    private void configureEncryption(IBoxHolder iBoxHolder) throws ConfigurationException {
        if (this.boxEncryption != null) {
            try (FileInputStream fis = new FileInputStream(this.boxEncryption.getPrivateKeyFile());){
                this.keyPair = CryptoUtils.loadKeyStore((InputStream)fis, (String)this.boxEncryption.getPrivateKeyFilePassword(), (String)this.boxEncryption.getKeyStoreType()).getKeyPair(this.boxEncryption.getKeyAlias(), this.boxEncryption.getKeyPassword());
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                Output.printError("Could not load keystore");
                throw new ConfigurationException(iBoxHolder, "Could not load keystore");
            }
        }
    }
}

