/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.s3tool.Bucket.Upload;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.MailDocumentId;
import de.lwsystems.mailarchive.archive.container.ContainerNotFoundException;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.s3tool.Benno.Box.BennoBoxReader;
import de.lwsystems.mailarchive.s3tool.Benno.Container.BennoContainer;
import de.lwsystems.mailarchive.s3tool.Benno.Container.BennoContainerStorage;
import de.lwsystems.mailarchive.s3tool.Benno.Encryption.EncryptionMessage;
import de.lwsystems.mailarchive.s3tool.Output.Output;
import de.lwsystems.mailarchive.s3tool.Utils.FS;
import de.lwsystems.mailarchive.s3tool.Utils.MailDocumentUtils;
import de.lwsystems.mailarchive.storage.s3.S3BoxStorage;
import de.lwsystems.mailarchive.storage.s3.S3BoxStorageConfig;
import de.lwsystems.mailarchive.utils.CompressionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;

public class UploadObject {
    private BennoContainerStorage bennoContainerStorage;

    public UploadObject(BennoContainerStorage bennoContainerStorage) {
        this.bennoContainerStorage = bennoContainerStorage;
    }

    public void uploadObjects(BennoContainer bennoContainer) {
        bennoContainer.getBennoBoxes().getContainerBoxMap().forEach((container, boxes) -> boxes.forEach(box -> {
            try {
                BennoBoxReader bennoBoxReader = new BennoBoxReader((IBox)box, false);
                if (bennoBoxReader.isBoxS3()) {
                    this.uploadObject((IBox)box, container.getIdentifier());
                }
            }
            catch (ArchiveException e) {
                Output.printError("Could not read box " + e.getMessage());
            }
        }));
    }

    private void uploadObject(IBox box, String container) {
        FS.getFileStream(box, box.getIdentifier()).forEach(f -> {
            try {
                if (!this.uploadObject((File)f, box, container)) {
                    Output.printError("Could not upload file " + f.getAbsolutePath());
                }
            }
            catch (ContainerNotFoundException e) {
                Output.printError(e.getMessage());
            }
        });
    }

    private boolean uploadObject(File sourceFile, IBox iBox, String container) throws ContainerNotFoundException {
        MailDocumentId mailDocumentId = MailDocumentUtils.createMailDocumentId(sourceFile, iBox);
        try {
            File tempFile = FS.createDuplicateFile(sourceFile, iBox);
            MailDocument mailDocument = new MailDocument(Files.readAllBytes(tempFile.toPath()), null);
            OutputStream mailOutputStream = CompressionUtil.getOutStream((File)tempFile, (IBox.CompressionType)iBox.getBoxConfig().getCompression());
            EncryptionMessage encryptionMessage = new EncryptionMessage(iBox);
            mailOutputStream = encryptionMessage.encryptMessage(mailOutputStream);
            FS.writeToFile(mailOutputStream, mailDocument);
            this.uploadObjectToBucket(container, iBox, mailDocumentId, tempFile);
            Output.printUploadedMail(sourceFile.getAbsolutePath(), ((S3BoxStorageConfig)iBox.getBoxConfig().getBoxStorageConfig()).getBucket());
            FS.removeFiles(tempFile, sourceFile);
            return true;
        }
        catch (Exception e) {
            Output.printError(e.getMessage());
            return false;
        }
    }

    private void uploadObjectToBucket(String container, IBox iBox, MailDocumentId mailDocumentId, File tempFile) throws Exception {
        try (FileInputStream inputStream = new FileInputStream(tempFile);){
            S3BoxStorage storage = this.bennoContainerStorage.getStorage(container, iBox.getIdentifier());
            storage.uploadObject(mailDocumentId, iBox.getBoxConfig().getCompression(), inputStream);
        }
        catch (IOException e) {
            Output.printError(e.getMessage());
        }
    }
}

