/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.s3tool.Mail;

import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.s3tool.Output.Output;
import de.lwsystems.mailarchive.s3tool.Utils.FS;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class FSMails {
    private boolean foundOpenMails = false;

    public void listOpenMails(Map<IContainer, List<IBox>> containerBoxMap) {
        containerBoxMap.forEach(this::listRepoMails);
    }

    private void listRepoMails(IContainer iContainer, List<IBox> iBoxes) {
        this.foundOpenMails = false;
        Output.printContainerHeadline(iContainer.getIdentifier());
        iBoxes.forEach(this::listMails);
        if (!this.foundOpenMails) {
            Output.printMessage("No open mails found in container");
        }
    }

    private void listMails(IBox box) {
        Stream<File> fileStream = this.listObjects(box, box.getIdentifier());
        if (fileStream.count() > 0L) {
            Output.printStream(this.listObjects(box, box.getIdentifier()));
            this.foundOpenMails = true;
        }
    }

    private Stream<File> listObjects(IBox iBox, String box) {
        return FS.getFileStream(iBox, box);
    }
}

