/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.s3tool.Main;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.ArchiveNotFoundException;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.MailDocumentId;
import de.lwsystems.mailarchive.archive.container.ContainerNotFoundException;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.s3tool.Benno.Box.S3Boxes;
import de.lwsystems.mailarchive.s3tool.Benno.Container.BennoContainer;
import de.lwsystems.mailarchive.s3tool.Benno.Container.BennoContainerStorage;
import de.lwsystems.mailarchive.s3tool.Config.Configuration;
import de.lwsystems.mailarchive.s3tool.Output.Output;
import de.lwsystems.mailarchive.s3tool.Service.BucketService;
import de.lwsystems.mailarchive.s3tool.Service.BucketStatsService;
import de.lwsystems.mailarchive.s3tool.Service.ContainerService;
import de.lwsystems.mailarchive.s3tool.Service.ObjectServiceImpl;
import de.lwsystems.mailarchive.s3tool.Service.RepoMailService;
import de.lwsystems.mailarchive.s3tool.Utils.BennoIBoxReaderUtils;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;

public class S3Tool {
    private final CommandLine cmdl;
    private final String container;
    private final String bennoId;
    private final Configuration configuration;
    private final boolean quiteMode;

    public S3Tool(CommandLine cmdl, Configuration configuration) {
        this.configuration = configuration;
        this.cmdl = cmdl;
        this.container = cmdl.getOptionValue("C");
        this.bennoId = cmdl.getOptionValue("id");
        this.quiteMode = cmdl.hasOption("q");
    }

    public void start() throws Exception {
        BennoContainer bennoContainer = this.createBennoContainer(this.configuration.getBenno());
        if (this.isContainerEmpty(bennoContainer)) {
            Output.printError("No S3 containers found in benno.xml");
            System.exit(1);
        }
        if (this.cmdl.hasOption("s")) {
            this.handleStatsOption(bennoContainer);
        } else if (this.cmdl.hasOption("id") && !this.cmdl.hasOption("rm")) {
            this.handleIdOption(bennoContainer);
        } else if (this.cmdl.hasOption("u")) {
            this.handleUploadOption(bennoContainer);
        } else if (this.cmdl.hasOption("lo")) {
            this.handleListObjectsOption(bennoContainer);
        } else if (this.cmdl.hasOption("rm")) {
            if (!this.cmdl.hasOption("id")) {
                this.handleRemoveOption(bennoContainer);
            } else {
                this.handleRemoveObjectFromBucketOption(bennoContainer);
            }
        } else if (this.cmdl.hasOption("lm")) {
            this.handleListRepoMailsOption(bennoContainer);
        } else if (this.cmdl.hasOption("bc")) {
            this.handleBucketContainerOption(bennoContainer);
        } else {
            Output.printError("No command given");
        }
    }

    private void handleStatsOption(BennoContainer bennoContainer) {
        BucketStatsService bucketStatsService = new BucketStatsService();
        Map<String, Map<String, Object>> containerBucketStats = bucketStatsService.getContainerBucketStats(new BennoContainerStorage(bennoContainer, this.configuration.getBenno()), bennoContainer);
        containerBucketStats.forEach((name, bucketStats) -> {
            Output.printContainerHeadline(name);
            Output.printMap((Map)containerBucketStats.get(name));
        });
    }

    private void handleIdOption(BennoContainer bennoContainer) {
        if (this.container != null && this.bennoId != null) {
            ObjectServiceImpl objectService = new ObjectServiceImpl(bennoContainer, this.configuration.getBenno());
            if (!this.quiteMode) {
                Output.printMailHeadline(this.container, this.bennoId);
            }
            try (BufferedOutputStream mailOutput = objectService.getRawObject(this.bennoId, bennoContainer, this.container);){
                Output.printReader(mailOutput);
            }
            catch (ArchiveException | ContainerNotFoundException | IOException e) {
                Output.printError(e.getMessage());
            }
        } else {
            Output.printError("Missing id or container for getting mail from S3");
            Runtime.getRuntime().exit(1);
        }
    }

    private void handleRemoveObjectFromBucketOption(BennoContainer bennoContainer) {
        block5: {
            BucketService bucketService = new BucketService();
            BennoContainerStorage bennoContainerStorage = new BennoContainerStorage(bennoContainer, this.configuration.getBenno());
            if (this.container != null && this.bennoId != null) {
                try {
                    Output.printContainerHeadline(this.container);
                    MailDocumentId documentId = new MailDocumentId(this.bennoId);
                    if (bucketService.removeObject(documentId, this.container, bennoContainerStorage.getStorage(this.container), BennoIBoxReaderUtils.getActualBox(this.configuration.getBenno(), this.container).getBoxConfig().getCompression())) {
                        Output.printSuccess("Removed object " + this.bennoId + " from container: " + this.container);
                        break block5;
                    }
                    Output.printError("Could not remove object from container: " + this.container);
                }
                catch (ArchiveException | ContainerNotFoundException e) {
                    Output.printError(e.getMessage());
                }
            } else {
                Output.printError("No container given");
                Runtime.getRuntime().exit(1);
            }
        }
    }

    private void handleRemoveOption(BennoContainer bennoContainer) {
        block5: {
            BucketService bucketService = new BucketService();
            BennoContainerStorage bennoContainerStorage = new BennoContainerStorage(bennoContainer, this.configuration.getBenno());
            if (this.container != null) {
                try {
                    Output.printContainerHeadline(this.container);
                    if (bucketService.removeBucket(this.container, bennoContainerStorage.getStorage(this.container))) {
                        Output.printSuccess("Removed bucket from container: " + this.container);
                        break block5;
                    }
                    Output.printError("Could not remove bucket from container: " + this.container);
                }
                catch (ArchiveException | ContainerNotFoundException e) {
                    Output.printError(e.getMessage());
                }
            } else {
                Output.printError("No container given");
                Runtime.getRuntime().exit(1);
            }
        }
    }

    private void handleBucketContainerOption(BennoContainer bennoContainer) {
        ContainerService containerService = new ContainerService();
        for (Map.Entry<IContainer, List<IBox>> containerMap : bennoContainer.getBennoBoxes().getContainerBoxMap().entrySet()) {
            Output.printContainerHeadline(containerMap.getKey().getIdentifier());
            Output.printContainerBucketConfiguration(containerService.getContainerList(containerMap.getKey()));
        }
    }

    private void handleListRepoMailsOption(BennoContainer bennoContainer) {
        RepoMailService repoMailService = new RepoMailService();
        repoMailService.listOpenRepoMails(bennoContainer);
    }

    private void handleListObjectsOption(BennoContainer bennoContainer) {
        ObjectServiceImpl objectService = new ObjectServiceImpl(bennoContainer, this.configuration.getBenno());
        objectService.printObjects(bennoContainer);
    }

    private void handleUploadOption(BennoContainer bennoContainer) {
        ObjectServiceImpl objectService = new ObjectServiceImpl(bennoContainer, this.configuration.getBenno());
        objectService.uploadTempObjects(bennoContainer);
    }

    private boolean isContainerEmpty(BennoContainer bennoContainer) {
        return bennoContainer.getBennoBoxes().getContainerBoxMap() == null || bennoContainer.getBennoBoxes().getContainerBoxMap().isEmpty();
    }

    private BennoContainer createBennoContainer(Benno benno) throws ArchiveNotFoundException, ContainerNotFoundException {
        if (this.container != null && !this.container.isEmpty()) {
            return new BennoContainer(new S3Boxes(benno, this.container));
        }
        return new BennoContainer(new S3Boxes(benno));
    }
}

