/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.s3tool.Service;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.MailDocumentId;
import de.lwsystems.mailarchive.archive.container.ContainerNotFoundException;
import de.lwsystems.mailarchive.s3tool.Benno.Container.BennoContainer;
import de.lwsystems.mailarchive.s3tool.Benno.Container.BennoContainerStorage;
import de.lwsystems.mailarchive.s3tool.Bucket.Upload.UploadObject;
import de.lwsystems.mailarchive.s3tool.Mail.Mail;
import de.lwsystems.mailarchive.s3tool.Output.Output;
import de.lwsystems.mailarchive.s3tool.Service.ObjectService;
import de.lwsystems.mailarchive.s3tool.Utils.BennoIBoxReaderUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;

public class ObjectServiceImpl
implements ObjectService {
    private final BennoContainerStorage bennoContainerStorage;
    private final Benno benno;

    public ObjectServiceImpl(BennoContainer bennoContainer, Benno benno) {
        this.benno = benno;
        this.bennoContainerStorage = new BennoContainerStorage(bennoContainer, benno);
    }

    @Override
    public ByteArrayOutputStream getObject(String bennoId, BennoContainer bennoContainer, String container) throws ContainerNotFoundException, ArchiveException {
        String boxIndentifier = new MailDocumentId(bennoId).getInternalBoxIndentifier();
        Mail mail = new Mail(bennoId, BennoIBoxReaderUtils.getBennoIBox(this.benno, container, boxIndentifier));
        return mail.getMailByteArrayOutputStream();
    }

    @Override
    public BufferedOutputStream getRawObject(String bennoId, BennoContainer bennoContainer, String container) throws ContainerNotFoundException, ArchiveException {
        String boxIndentifier = new MailDocumentId(bennoId).getInternalBoxIndentifier();
        Mail mail = new Mail(bennoId, BennoIBoxReaderUtils.getBennoIBox(this.benno, container, boxIndentifier));
        return mail.getMailBufferedOutputStream();
    }

    @Override
    public void uploadTempObjects(BennoContainer bennoContainer) {
        UploadObject uploadObject = new UploadObject(this.bennoContainerStorage);
        uploadObject.uploadObjects(bennoContainer);
    }

    @Override
    public void printObjects(BennoContainer bennoContainer) {
        bennoContainer.getBennoBoxes().getContainerBoxMap().forEach((container, box) -> {
            try {
                Output.printContainerHeadline(container.getIdentifier());
                this.bennoContainerStorage.getStorage(container.getIdentifier(), ((IBox)box.get(0)).getIdentifier()).printBucketObjects();
            }
            catch (ArchiveException | ContainerNotFoundException e) {
                Output.printError(e.getMessage());
            }
        });
    }
}

