/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.s3tool.Utils;

import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.utils.CompressionUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;

public final class FS {
    private static Predicate<File> filesWithoutSuffix = f -> !f.getName().contains(".");
    private static Predicate<File> notDirectory = f -> !f.isDirectory();
    private static Predicate<File> isHexString = f -> f.getName().matches("^[0-9a-fA-F]+$");
    private static Predicate<File> filePredicateChain = filesWithoutSuffix.and(notDirectory).and(isHexString);

    public static File createDuplicateFile(File sourceFile, IBox iBox) {
        File tempFile = FS.createTempFile(sourceFile, iBox);
        FS.copyFile(sourceFile, tempFile);
        return tempFile;
    }

    private static File createFile(IBox iBox, String box) {
        return new File(iBox.getRepoPath() + File.separator + box);
    }

    public static Stream<File> getFileStream(IBox iBox, String box) {
        File file = FS.createFile(iBox, box);
        return Arrays.stream(Objects.requireNonNull(file.listFiles())).filter(filePredicateChain);
    }

    private static File createTempFile(File file, IBox iBox) {
        String fileName = file.getAbsolutePath() + "_tmp" + CompressionUtil.getCompressionSuffix((IBox.CompressionType)iBox.getBoxConfig().getCompression());
        return new File(fileName);
    }

    public static void copyFile(File source, File target) {
        try {
            Files.copy(source.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void removeFiles(File ... files) {
        Arrays.stream(files).anyMatch(File::delete);
    }

    public static void writeToFile(OutputStream file, MailDocument mailDocument) throws IOException {
        file.write(mailDocument.getMailData());
        file.flush();
        file.close();
    }
}

