<?php

class CsrfToken
{
    public static $actions = array();

    public static function generate()
    {
        if (!isset($_SESSION['csrf_token'])) {
            $_SESSION['csrf_token'] = bin2hex(openssl_random_pseudo_bytes(16));
        }
    }

    public static function getCsrfToken()
    {
        return $_SESSION['csrf_token'];
    }

    public static function validate($token)
    {
        if (isset($_SESSION['csrf_token']) && $_SESSION['csrf_token'] === $token) {
            return true;
        } else {
            return false;
        }
    }
}

