<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */

/** $Id: $
 *
 */
/**
 * @package User
 */
/**
 *
 * Abstract class to access User object data from storage
 *
 */
require_once 'model/Filter.php';


class ExternalAuth
{

    private $userobj;


    // load userdata from external userdb via script stdin/out
    function __construct ($userobj,$authprg,$password='')
    {
        global $App;

        $this->userobj = $userobj;
        $username = $this->userobj->id;

        $fd = array(
            0 => array('pipe', 'r'),
            1 => array('pipe', 'w'),
            2 => array('pipe', 'w')
        );

        $cmd = escapeshellcmd($authprg);
        $process = proc_open($cmd, $fd, $pipes);
        $App->log('Call "'.$authprg.'" to authenticate.',2,'ExternalAuth');

        $auth_sep = ' ';
        // check for whitespace (FS#140)
        if (strpos($username,' ') !== false) {
            $auth_sep = "\n"; 
            $App->log('WARN: Username contains whitespace: Use \n as separator');
        }
        if (strpos($password,' ') !== false) {
            $auth_sep = "\n"; 
            $App->log('WARN: Password contains whitespace: Use \n as separator');
        }

        if (is_resource($process)) {
            // write "<username>$auth_sep<password>"
            fwrite($pipes[0], $username.$auth_sep.$password);
            fclose($pipes[0]);

            // read stdout from script
            $retvalue = stream_get_contents($pipes[1]);
            fclose($pipes[1]);

            $errvalue = stream_get_contents($pipes[2]);
            fclose($pipes[2]);
            if ($errvalue) {
                $error_lines = '';
                $loglevel = 3;
                foreach (explode("\n", $errvalue) as $error_line) {
                    if (preg_match('/FATAL/',$error_line)) {
                        $loglevel = 0;
                    }
                    $error_lines .= $error_line.'|';
                }
                $error_lines = rtrim($error_lines, '|');
                $App->log('Authentication script error: '.$error_lines,$loglevel,'User/loadSExternal');
            }

            $return_value = proc_close($process);
        }
        // Returnvalues:
        //  ERROR ERR_AUTH | ERR_INTERN | (symbol in benno-errors.txt)
        //  ROLE USER | REVISOR | ADMIN
        //  DISPLAYNAME Martin Werthmöller
        //  ARCHIVE LWsystems
        //  MAIL mw@lw-systems.de
        //  MAIL m.werthmoeller@lw-systems.de
        //  MAIL info@lw-systems.de
        //  USERID <internal_userid>
        return $this->map_lines($retvalue);
    }


    private function map_lines($retvalue) {
        global $App;
        $retlines = preg_split('/\n/',$retvalue);
        foreach ($retlines as $line) {
            $line = trim($line);
            if (!$line) continue;
            @list($mark,$data) = preg_split('/\s/',$line,2);
            switch ($mark) {
                case 'ERROR':
                    throw new Exception($data);
                    break;
                case 'WARN':
                    $App->log('WARN '.$data,0);
                    break;
                case 'NOTE':
                    // only for cmdline debugging
                    break;
                case 'ROLE':
                    $this->userobj->role = $data;
                    break;
                case 'DISPLAYNAME':
                    $this->userobj->name = $data;
                    break;
                case 'ARCHIVE':
                    array_push($this->userobj->archive,$data);
                    break;
                case 'MAIL':
                    array_push($this->userobj->addresses,$data);
                    break;
                case 'AUTHPARAM':
                    $this->userobj->authparam = array_merge(
                            $this->userobj->authparam,$this->split_value($data));
                    break;
                case 'USERID':
                    $this->userobj->id = $data;
                    break;
                case 'FILTER':
                    list($fname,$fstr) = preg_split('/\s/',$data,2);
                    $Filter = new Filter($fname,$this->userobj->id,$fname,$fstr);
                    array_push($this->userobj->filter,$Filter);
                    break;
                case 'RESTURL':
                    $this->userobj->restdata['URL'] = $data;
                    break;
                case 'RESTUSER':
                    $this->userobj->restdata['USER'] = $data;
                    break;
                case 'RESTPASS':
                    $this->userobj->restdata['PASS'] = $data;
                    break;
            }
        }

        if (!$this->userobj->archive) {
            $App->log('ARCHIVE not set by external auth',1'ExternalAuth');
            throw new Exception('ERR_ARCHIVE');
        }
        $this->userobj->archive = array_unique($this->userobj->archive);

        if (!$this->userobj->role)    {
            $App->log('ROLE not set by external auth',1,'ExternalAuth');
            throw new Exception('ERR_AUTH');
        }

        if ($this->userobj->role == 'SYSTEM') { 
            $App->log('SYSTEM ROLE not allowed to login',1,'ExternalAuth');
            throw new Exception('ERR_AUTH');
        }

        $this->userobj->load_role_permissions();
        return FALSE;
    }


    // split ' ' into array
    public function split_value($authparam)
    {
        list($param,$value) = preg_split('/\s/',$authparam,2);
        $p[$param] = $value;

        return $p;
    }


}
?>
