<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */
include_once 'model/MailObject.php';

$PermaId = new PermaId();
$plink = $PermaId->encrypt($EMail->bennoId,$EMail->archive);

$MailObject = new MailObject($EMail->id,$plink);
$MailObject->from       = $EMail->getFrom();
$MailObject->to         = $EMail->getTo();
$MailObject->cc         = $EMail->getCc();
$MailObject->bcc        = $EMail->getBcc();
$MailObject->subject    = $EMail->getSubject();
$MailObject->verified   = $EMail->isVerified();

if ($App->getConfig('RESEND_MAILTO') == 'last') {
    $MailObject->resendMailto = $App->getSession('resendMailto');
}
else if ($App->getConfig('RESEND_MAILTO') == 'to') {
    preg_match_all("/[\._a-zA-Z0-9-]+@[\._a-zA-Z0-9-]+/i", $MailObject->to, $addrs);
    $resendAddr = '';
    foreach (array_unique($addrs[0]) as $addr) {
        $resendAddr .= $addr.', ';
    }
    $MailObject->resendMailto = rtrim($resendAddr,', ');
}

if ($USER->role == 'ADMIN') {
    $MailObject->bennoId    = $EMail->bennoId;
}

$atm_list = array();
foreach ($EMail->getAttachments() as $Attachment) {

    $openWindow = false;
    $show_inline = $App->getConfigList('ATTACHMENT_INLINE',array('application/pdf','image/png'));
    if (in_array($Attachment->type,$show_inline)) {     // --> ctrl/downloadAttachment
        $openWindow = true;
    }
    else { // show inline if file suffix matches
        $itype_list = $App->getConfiglist('ATTACHMENT_INLINE_SUFFIX',array('application/pdf','image/png'));
        foreach ($itype_list as $itype) {
        list($type,$isuffix) = explode('/',$itype);
            if (preg_match("/\.$isuffix$/i", $Attachment->id)) {
                $openWindow = true;
            }
        }
    }

    $atm['id']           = urlencode($Attachment->id);
    $atm['attachmentId'] = $Attachment->attachmentId;
    $atm['type']         = $Attachment->type;
    $atm['size']         = $Attachment->size;
    $atm['icon']         = $Attachment->getIcon();
    $atm['openWindow']   = $openWindow;
    array_push($atm_list,$atm);


}
$MailObject->attachments= $atm_list;

$default_contenttype = $App->getConfig('DEFAULT_CONTENTYPE','text/html');
try {
    $body_content = $EMail->getBody($default_contenttype);
    $body_type = $default_contenttype;
}
catch (Exception $e) {
    if ($e->getMessage() == 'NO_CONTENT') {
        if ($default_contenttype == 'text/html') {
            $body_type = 'text/plain';
        }
        else {
            $body_type = 'text/html';
        }
    }
}
try {
    $body_content = $EMail->getBody($body_type);

    if ((!$showImgs) && ($body_type == 'text/html'))  {    // remove images
        $body_content = preg_replace('/url\(.+?\)/','url(/* removed */)',$body_content);
        $dom = new DOMDocument();
        @$dom->loadHTML($body_content);
        $tags = @$dom->getElementsByTagName('img');
        foreach ($tags as $tag) {
            @$tag->getAttributeNode('src')->value = '';
        }
        $body_content = $dom->saveHTML();
        // remove url in css
    }

}
catch (Exception $e) {
    $App->log('Cannot fetch email body: '.$e->getMessage(),1,'a_showEmail');
}

$mailDate = $EMail->getDate();
$MailObject->setDate($mailDate,$LOCALE['dateformat']);
$MailObject->setTime($mailDate,$LOCALE['timeformat']);
$MailObject->setBody($body_content,$body_type);

if (isset($errorMsg)) {
    $MailObject->setError('ID_NOT_FOUND');
}
$App->response(json_encode($MailObject),'application/json');
?>
