package Benno::Config;

=head1 NAME

Benno::Config

=head1 SYNOPSIS

    use C<Benno::Config>;

=head1 DESCRIPTION

    Common used methods and functions.

=head2 new ($configfile)

    Create Benno::Config object

=cut
sub new
{
    my ($class,$configfile) = @_;

    my $self = {};
    bless $self, $class;

    $self->_init($configfile);

    return $self;
}


# read_config
sub _init
{
  my ($self,$configfile) = @_;
  # _very_ simple config file parser
  #
  # Config format:   var = val
  #
  open CONF, "$configfile" or die "Cannot open config file $configfile. $!\n";
  foreach my $line (<CONF>) {
      next if $line =~ /^$/;
      next if $line =~ /^#/;
      chomp $line;
      my ($var,$val) = split(/=/, $line,2);
      # strip ws
      $var =~ s/\s//g;
      $val =~ s/^\s+//g;
      $val =~ s/\s+$//g;

      if ($val =~ /^\</) {  # read file content
        $val = $self->_file_value($val);
      }

      $self->{$var} = $val;
  }
  close CONF;
  return $config;
}


# read config value from file
sub _file_value
{
    my ($self,$configval) = @_;
    my $retval;

    (my $file = $configval) =~ s/^\<//;
    eval {
        local $/;
        open(my $fh, '<', $file) or die "Cannot read $file: $!\n";
        $retval = <$fh>;
        close($fh);
    };
    if ($@) {
        print STDERR "WARNING $@";
        return $configval;
    }
    chomp $retval;
    return $retval;
}


=head1 get($param)

    Returns the value of the config parameter. 

=cut
sub get
{
    my ($self,$param) = @_;

    my $val = $self->{$param};
    $val = 1 if $val =~ /^(true|ok|yes)$/i;
    $val = 0 if $val =~ /^(false|no)$/i;

    return $val;
}


=head1 get_list($param)

    Returns the value of the config parameter. 
    If called in list context, the method splits comma or whitespace
    separated lines and returns an array.

=cut
sub get_list
{
    my ($self,$param) = @_;

    return $self->{$param} =~ /[^,\s]+/g;
}


=head1 set($param,$value)

    Sets the value of the config parameter

=cut
sub set
{
    my ($self,$param,$value) = @_;

    return $self->{$param} = $value;
}





### EOP ###
1;

