/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoarchive;

import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.bennoarchive.BennoArchive;
import de.lwsystems.mailarchive.bennoarchive.archive.ContainerTools;
import de.lwsystems.mailarchive.bennoarchive.directory.RemoveDirectory;
import de.lwsystems.mailarchive.bennoarchive.exception.PasswordFileNotFoundException;
import de.lwsystems.mailarchive.bennoarchive.exception.PasswordNotMatchException;
import de.lwsystems.mailarchive.bennoarchive.removedocument.RemoveAuthorization;
import de.lwsystems.mailarchive.bennoarchive.removedocument.RemoveDocumentIndex;
import de.lwsystems.mailarchive.bennoarchive.softremove.SoftRemoveMailDocument;
import de.lwsystems.mailarchive.log.LogClass;
import de.lwsystems.mailarchive.log.RemoveLogClass;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.remove.RemoveDocument;
import de.lwsystems.mailarchive.utils.BennoBuildTime;
import de.lwsystems.mailarchive.utils.BennoVersion;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Optional;
import org.apache.log4j.Logger;

public class ManagementClient
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ManagementClient.class);
    private final BennoArchive archive;
    private final Socket client;
    private boolean running = false;
    private RemoveDocument removeDocument;
    private boolean isRemoveActive = false;
    private boolean authenticatedForRemove = false;
    private String mode;
    private Optional<String> bennoMailId = Optional.empty();

    protected ManagementClient(BennoArchive archive, Socket client) {
        this.archive = archive;
        this.client = client;
    }

    @Override
    public void run() {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(this.client.getInputStream()));
            PrintWriter out = new PrintWriter(this.client.getOutputStream(), true);
            String hostname = "Unknown";
            String ip = "Unknown";
            try {
                InetAddress local = InetAddress.getLocalHost();
                ip = local.getHostAddress();
                hostname = local.getHostName();
            }
            catch (UnknownHostException local) {
                // empty catch block
            }
            this.running = true;
            while (this.running) {
                try {
                    this.handleManagementCommand(in, out);
                    if (this.running) continue;
                    this.client.close();
                }
                catch (IOException e) {
                    this.running = false;
                    this.client.close();
                }
            }
        }
        catch (IOException ex) {
            LOGGER.warn((Object)"Initialization of management client failed", (Throwable)ex);
        }
    }

    private void printManagementHelp(PrintWriter out) {
        out.println("quit                            End this management session");
        out.println("stop                            Stop this mailarchive server");
        out.println("show info                       Show information about this installation");
        out.println("list archives                   List archives");
        out.println("list services                   List services");
        out.println("start services                  Start services");
        out.println("stop services                   Stop services");
    }

    public void initiateRemoveMailFromIndex(BufferedReader in) throws IOException {
        this.handleManagementCommand(in, new PrintWriter(this.client.getOutputStream(), true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleManagementCommand(BufferedReader in, PrintWriter out) {
        block34: {
            try {
                StringBuilder everything = new StringBuilder();
                String command = in.readLine();
                if (command.equals("stop")) {
                    out.println("Goodbye!");
                    this.running = false;
                    this.archive.shutDown();
                    break block34;
                }
                if (command.equals("quit")) {
                    this.running = false;
                    break block34;
                }
                if (command.equals("help")) {
                    this.printManagementHelp(out);
                    break block34;
                }
                if (command.equals("show info")) {
                    out.println("bennoarchive: " + BennoVersion.archiveVersion() + " (" + BennoBuildTime.archiveBuildTime() + ")");
                    out.println("bennocore: " + BennoVersion.coreVersion() + " (" + BennoBuildTime.coreBuildTime() + ")");
                    out.println(this.archive.getConfigString());
                    break block34;
                }
                if (command.equals("list archives")) {
                    this.archive.listArchives(out);
                    break block34;
                }
                if (command.equals("list services")) {
                    this.archive.listServices(out);
                    break block34;
                }
                if (command.equals("start services")) {
                    out.println("Starting services...");
                    this.archive.startServices();
                    this.archive.listServices(out);
                    break block34;
                }
                if (command.equals("stop services")) {
                    out.println("Stopping services...");
                    this.archive.stopServices();
                    this.archive.listServices(out);
                    break block34;
                }
                if (command.equals("delindex")) {
                    this.isRemoveActive = true;
                    break block34;
                }
                if (this.isRemoveActive && command.equals("soft")) {
                    this.mode = command.toLowerCase();
                    this.removeDocument = RemoveDocument.getInstance((String)this.mode);
                    break block34;
                }
                if (this.isRemoveActive && command.equals("hard")) {
                    this.mode = command.toLowerCase();
                    this.removeDocument = RemoveDocument.getInstance((String)this.mode);
                    this.removeDocument.activateHardRemove();
                    break block34;
                }
                if (this.isRemoveActive) {
                    if (this.authenticatedForRemove) {
                        if (!this.bennoMailId.isPresent()) {
                            this.bennoMailId = Optional.of(command.toUpperCase());
                        } else {
                            IContainer myContainer = ContainerTools.getContainer(command, this.archive.getBenno());
                            RemoveDocumentIndex removeDocumentIndex = new RemoveDocumentIndex(myContainer, this.bennoMailId);
                            if (!removeDocumentIndex.existsDocumentInIndex()) {
                                out.println("Error: Mail " + removeDocumentIndex.getBennoMailId() + " is not present in index. Nothing is deleted.");
                            } else {
                                MailDocument myDoc = removeDocumentIndex.getMailFromRepo();
                                if (this.removeDocument.isInstanceSet(this.mode)) {
                                    if (this.removeDocument.isHardRemove()) {
                                        if (!this.removeDocument.existsDocumentInStack(myDoc)) {
                                            this.removeDocument.reserveDocumentForRemoving(myDoc);
                                            out.println("OK: Mail reserved for hard delete : " + removeDocumentIndex.getBennoMailId());
                                        } else {
                                            out.println("Error: Mail exists in stack : " + removeDocumentIndex.getBennoMailId());
                                        }
                                    } else if (!this.removeDocument.existsDocumentInStack(myDoc = new SoftRemoveMailDocument(myDoc))) {
                                        try {
                                            RemoveDirectory removeDirectory = new RemoveDirectory(myContainer.getBoxGenerator().getState().getActualBox().getRepoPath());
                                            LogClass removeLogClass = RemoveLogClass.getInstance((String)myContainer.getIdentifier(), (String)removeDirectory.getRemoveDirectory().toAbsolutePath().toString());
                                            removeLogClass.addEntry(new String[]{removeDocumentIndex.getBennoMailId()});
                                            out.println("OK: Mail reserved for soft delete : " + removeDocumentIndex.getBennoMailId());
                                            this.removeDocument.reserveDocumentForRemoving(myDoc);
                                        }
                                        catch (IOException ex) {
                                            out.println(ex.getMessage());
                                            this.running = false;
                                        }
                                    } else {
                                        out.println("Error: Mail exists in stack : " + removeDocumentIndex.getBennoMailId());
                                    }
                                } else {
                                    out.println("Error: Stack is not initialized for " + this.mode + " delete");
                                }
                                this.bennoMailId = Optional.empty();
                            }
                            this.running = false;
                        }
                    } else {
                        RemoveAuthorization removeAuthorization = new RemoveAuthorization();
                        try {
                            this.authenticatedForRemove = removeAuthorization.checkAuthorizationForDeleting(command);
                        }
                        catch (PasswordFileNotFoundException | PasswordNotMatchException ex) {
                            out.println(ex.getMessage());
                            this.running = false;
                        }
                    }
                    break block34;
                }
                out.println("Unknown command \"" + command + "\"");
                this.printManagementHelp(out);
            }
            catch (Throwable exception) {
                out.println(exception.getMessage());
                this.running = false;
            }
        }
    }

    public void stop() {
        this.running = false;
    }
}

