/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoarchive.archive;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.ConfiguredArchiveGenerator;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.container.ContainerNotFoundException;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.archive.container.IContainerGenerator;
import de.lwsystems.mailarchive.config.BennoConfig;
import java.util.HashMap;
import java.util.Map;

public class ContainerTools {
    static final boolean readOnly = true;

    public static IContainer getContainer(String searchContainer, Benno benno) throws ContainerNotFoundException {
        BennoConfig config = benno.getConfig();
        IContainer myContainer = null;
        for (IArchive aktArchive : new ConfiguredArchiveGenerator(benno, config.getArchiveGenerator(), true).getArchives()) {
            IContainerGenerator containerGen = aktArchive.getContainerGenerator();
            try {
                myContainer = containerGen.getContainer(searchContainer);
                break;
            }
            catch (Exception searchEx) {
            }
        }
        if (myContainer == null) {
            throw new ContainerNotFoundException(searchContainer);
        }
        return myContainer;
    }

    public static Map<String, IContainer> getContainerList(Benno benno) throws Exception {
        HashMap<String, IContainer> containerList = new HashMap<String, IContainer>();
        BennoConfig config = benno.getConfig();
        for (IArchive aktArchive : new ConfiguredArchiveGenerator(benno, config.getArchiveGenerator(), true).getArchives()) {
            IContainerGenerator containerGen = aktArchive.getContainerGenerator();
            try {
                for (IContainer container : containerGen.getContainers()) {
                    if (container.getIdentifier().equals("SYSDATA")) continue;
                    containerList.put(container.getIdentifier(), ContainerTools.getContainer(container.getIdentifier(), benno));
                }
            }
            catch (Exception ex) {
                throw new Exception("Unexcpeted excpetion: ");
            }
        }
        return containerList;
    }
}

