/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive;

import de.lwsystems.mailarchive.utils.License;
import java.util.Date;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class LicenseGenerator {
    public static void main(String[] args) throws ParseException {
        Object addrHost;
        String licenseType = "";
        String hostOrInstanceId = "";
        String expires = "never";
        Object inputData = "";
        String licensee = "";
        String mailDomain = "";
        String numMailboxes = "";
        String plugin = "";
        License lic = new License();
        if (args.length == 0) {
            System.err.print(LicenseGenerator.getHelp());
            Runtime.getRuntime().exit(1);
        }
        Options options = new Options();
        options.addOption("h", false, "print help");
        options.addOption("l", true, "licensee name");
        options.addOption("t", true, "license type (Evaluation|<Benno-$flavor>)");
        options.addOption("i", true, "host info string");
        options.addOption("e", true, "exires (YYYY-MM-DD)");
        options.addOption("m", true, "primary maildomain");
        options.addOption("n", true, "number of mailboxes");
        options.addOption("a", true, "instance id");
        options.addOption("p", true, "plugin");
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        if (cmd.hasOption("h")) {
            System.out.print(LicenseGenerator.getHelp());
        }
        if (cmd.hasOption("l")) {
            licensee = cmd.getOptionValue("l").trim();
        } else {
            System.err.print("Lizenznehmer nicht angegeben.\n");
            System.err.print(LicenseGenerator.getHelp());
            Runtime.getRuntime().exit(2);
        }
        if (cmd.hasOption("t")) {
            licenseType = cmd.getOptionValue("t").trim();
        } else {
            System.err.print("End-Datum der Lizenz wurde nicht angegeben.\n");
            System.err.print(LicenseGenerator.getHelp());
            Runtime.getRuntime().exit(2);
        }
        String descriptionHostOrInstanceIdText = "";
        if (cmd.hasOption("i") && !cmd.hasOption("a")) {
            hostOrInstanceId = cmd.getOptionValue("i").trim();
            addrHost = hostOrInstanceId.split("/");
            if (addrHost[1].indexOf(".") == -1) {
                System.err.print("Hostname ist kein FQDN.\n");
                Runtime.getRuntime().exit(4);
            }
            if (addrHost[0].startsWith("127.")) {
                System.err.print("IP-Adresse ist ungueltig, da Loopback-Device.\n");
                Runtime.getRuntime().exit(5);
            }
            descriptionHostOrInstanceIdText = "Host-Info:";
        } else if (cmd.hasOption("a") && !cmd.hasOption("i")) {
            hostOrInstanceId = cmd.getOptionValue("a");
            descriptionHostOrInstanceIdText = "Instance-ID:";
        } else {
            System.err.print("Host-Info String bzw. Instance-ID wurde nicht angegeben.\n");
            System.err.print(LicenseGenerator.getHelp());
            Runtime.getRuntime().exit(2);
        }
        if (cmd.hasOption("e")) {
            expires = cmd.getOptionValue("e").trim();
            try {
                addrHost = License.getDate4String(expires);
            }
            catch (java.text.ParseException ex) {
                System.err.println("Datum ist nicht im Format \"YYYY-MM-DD\"");
                Runtime.getRuntime().exit(3);
            }
        } else {
            System.err.print("End-Datum der Lizenz nicht angegeben.\n");
            System.err.print(LicenseGenerator.getHelp());
            Runtime.getRuntime().exit(2);
        }
        if (cmd.hasOption("e")) {
            expires = cmd.getOptionValue("e").trim();
            try {
                Date ex = License.getDate4String(expires);
            }
            catch (java.text.ParseException ex) {
                System.err.println("Datum ist nicht im Format \"YYYY-MM-DD\"");
                Runtime.getRuntime().exit(3);
            }
        } else {
            System.err.print("End-Datum der Lizenz nicht angegeben.\n");
            System.err.print(LicenseGenerator.getHelp());
            Runtime.getRuntime().exit(2);
        }
        if (cmd.hasOption("m")) {
            mailDomain = cmd.getOptionValue("m").trim();
        } else {
            System.err.print("Prim\u00e4re Maildomain nicht angegeben.\n");
            System.err.print(LicenseGenerator.getHelp());
            Runtime.getRuntime().exit(2);
        }
        if (cmd.hasOption("n")) {
            numMailboxes = cmd.getOptionValue("n").trim();
        } else {
            System.err.print("Anzahl der Mailboxen nicht angegeben.\n");
            System.err.print(LicenseGenerator.getHelp());
            Runtime.getRuntime().exit(2);
        }
        if (cmd.hasOption("p")) {
            plugin = cmd.getOptionValue("p").trim();
        }
        inputData = lic.getIntSec() + "_" + hostOrInstanceId + "_" + expires + "_" + licenseType + "_" + licensee + "_" + mailDomain + "_" + numMailboxes;
        if (cmd.hasOption("p")) {
            inputData = (String)inputData + "_" + plugin;
        }
        String encodedInfo = lic.encodeString((String)inputData);
        System.out.println("## Lizenzdaten ###################################");
        System.out.println("Type:" + licenseType);
        System.out.println(descriptionHostOrInstanceIdText + hostOrInstanceId);
        System.out.println("Expires:" + expires);
        System.out.println("LicenseKey:" + encodedInfo);
        System.out.println("Licensee:" + licensee);
        System.out.println("PrimaryMaildomain:" + mailDomain);
        System.out.println("Mailboxes:" + numMailboxes);
        if (cmd.hasOption("p")) {
            System.out.println("Plugin:" + plugin);
        }
        System.out.println("##################################################");
    }

    public static String getHelp() {
        String help = "Aufruf: benno-license -t <license type> -l '<licensee>' (-i <IP-Adresse/FQDN> | -a <instance id>) -m <primary maildomain>' -n <number of mailboxes> -p <plugin> -e <YYYY-MM-DD>\n";
        return help;
    }
}

