/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.box;

import de.lwsystems.mailarchive.archive.box.INameIteratorStrategy;
import de.lwsystems.mailarchive.utils.Clock;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import org.joda.time.DurationFieldType;
import org.joda.time.LocalDate;

public class MultiNameIteratorStrategy
implements INameIteratorStrategy {
    private DateFormat dateFormat;
    private final DurationFieldType periodType;
    private final int periodMultiplier;

    public MultiNameIteratorStrategy(String format, DurationFieldType periodType, int periodMultiplier) {
        this.dateFormat = new SimpleDateFormat(format);
        this.periodType = periodType;
        this.periodMultiplier = periodMultiplier;
    }

    @Override
    public String getBoxNameForDate(Date date) {
        return this.dateFormat.format(date);
    }

    @Override
    public Iterator<String> getIterator() {
        return new Iterator<String>(){
            private LocalDate current;

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public String next() {
                this.current = this.current == null ? Clock.getProvider().newLocalDate() : this.current.withFieldAdded(MultiNameIteratorStrategy.this.periodType, MultiNameIteratorStrategy.this.periodMultiplier * -1);
                return MultiNameIteratorStrategy.this.getBoxNameForDate(this.current.toDate());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

