/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.authentication;

import de.lwsystems.mailarchive.authentication.AbstractAuthXmlPermission;
import de.lwsystems.mailarchive.authentication.AuthXmlPermissionRole;
import de.lwsystems.mailarchive.authentication.AuthXmlRole;
import de.lwsystems.mailarchive.authentication.AuthXmlUser;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;
import org.simpleframework.xml.core.Complete;
import org.simpleframework.xml.core.Persist;

@Root(name="authxml")
public class AuthXml {
    @ElementMap(entry="role", key="name", attribute=true, inline=true)
    private Map<String, AuthXmlRole> roles;
    @ElementMap(entry="user", key="name", attribute=true, inline=true)
    private Map<String, AuthXmlUser> users;
    private static final Logger LOGGER = LogManager.getLogger(AuthXml.class);

    @Root(name="xmlauth")
    public AuthXml() {
    }

    @Commit
    @Complete
    public void convertToRoles() {
        for (Map.Entry<String, AuthXmlUser> user : this.users.entrySet()) {
            for (AbstractAuthXmlPermission permission : user.getValue().permissions) {
                if (!(permission instanceof AuthXmlPermissionRole)) continue;
                AuthXmlPermissionRole role = (AuthXmlPermissionRole)permission;
                role.role = this.roles.get(role.rolename);
                role.rolename = null;
            }
        }
    }

    @Persist
    public void convertToRolenames() {
        for (Map.Entry<String, AuthXmlUser> user : this.users.entrySet()) {
            for (AbstractAuthXmlPermission permission : user.getValue().permissions) {
                AuthXmlPermissionRole rolepermission;
                if (!(permission instanceof AuthXmlPermissionRole) || (rolepermission = (AuthXmlPermissionRole)permission) == null) continue;
                for (Map.Entry<String, AuthXmlRole> role : this.roles.entrySet()) {
                    if (role.getValue() != rolepermission.role) continue;
                    rolepermission.rolename = role.getKey();
                    rolepermission.role = null;
                }
            }
        }
    }

    public Set<String> getUsers() {
        return this.users.keySet();
    }

    public AuthXmlUser getUser(String username) {
        return this.users.get(username);
    }
}

