/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.backup.service;

import java.util.Locale;

public enum BackupFormat {
    EML,
    GZIP;


    public String fileExtension() {
        return this == GZIP ? ".eml.gz" : ".eml";
    }

    public String tempFileSuffix() {
        return this == GZIP ? ".gz" : ".eml";
    }

    public static BackupFormat fromParam(String param) {
        if (param == null || param.isBlank()) {
            return EML;
        }
        return switch (param.toLowerCase(Locale.ROOT)) {
            case "gz", "gzip" -> GZIP;
            case "eml" -> EML;
            default -> throw new IllegalArgumentException("Invalid format: '" + param + "'. Supported values: eml, gz");
        };
    }
}

