/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.backup.service;

import de.lwsystems.mailarchive.backup.service.BackupArchiveStreamWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.CRC32;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

public class ZipArchiveStreamWriter
implements BackupArchiveStreamWriter {
    private static final int LOCAL_HEADER_FIXED = 30;
    private static final int CENTRAL_DIR_FIXED = 46;
    private static final int FOOTER_ESTIMATE = 100;
    private static final int BUFFER_SIZE = 65536;
    private final ZipArchiveOutputStream zipOut;
    private boolean hasBrokenEntry = false;

    public ZipArchiveStreamWriter(OutputStream out) {
        this.zipOut = new ZipArchiveOutputStream(out);
        this.zipOut.setUseZip64(Zip64Mode.Always);
    }

    @Override
    public void writeEntry(String entryPath, Path contentFile, long contentSize) throws IOException {
        long crc = this.computeCrc32(contentFile);
        ZipArchiveEntry entry = new ZipArchiveEntry(entryPath);
        entry.setMethod(0);
        entry.setSize(contentSize);
        entry.setCompressedSize(contentSize);
        entry.setCrc(crc);
        this.zipOut.putArchiveEntry((ArchiveEntry)entry);
        try {
            try (InputStream in = Files.newInputStream(contentFile, new OpenOption[0]);){
                int read;
                byte[] buf = new byte[65536];
                while ((read = in.read(buf)) != -1) {
                    this.zipOut.write(buf, 0, read);
                }
            }
            this.zipOut.closeArchiveEntry();
        }
        catch (IOException e) {
            try {
                this.zipOut.closeArchiveEntry();
            }
            catch (IOException suppressed) {
                this.hasBrokenEntry = true;
                e.addSuppressed(suppressed);
            }
            throw e;
        }
    }

    @Override
    public void finish() throws IOException {
        if (this.hasBrokenEntry) {
            try {
                this.zipOut.finish();
            }
            catch (IOException iOException) {}
        } else {
            this.zipOut.finish();
        }
    }

    @Override
    public long estimateEntryOverhead(long contentSize, int pathLength) {
        return (long)(30 + pathLength) + contentSize + 46L + (long)pathLength;
    }

    @Override
    public long estimateFooterSize() {
        return 100L;
    }

    @Override
    public String archiveExtension() {
        return ".zip";
    }

    @Override
    public void close() throws IOException {
        if (this.hasBrokenEntry) {
            try {
                this.zipOut.close();
            }
            catch (IOException iOException) {}
        } else {
            this.zipOut.close();
        }
    }

    private long computeCrc32(Path file) throws IOException {
        CRC32 crc = new CRC32();
        byte[] buf = new byte[65536];
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            int read;
            while ((read = in.read(buf)) != -1) {
                crc.update(buf, 0, read);
            }
        }
        return crc.getValue();
    }
}

