/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.journal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ChecksumValidator {
    private static final Pattern CHECKSUM_64_PATTERN = Pattern.compile("^[0-9A-Fa-f]{64}$");
    private static final Pattern CHECKSUM_66_PATTERN = Pattern.compile("^[0-9A-Fa-f]{66}$");
    private static final Pattern YEARBOX_PATTERN = Pattern.compile("^\\d{4}$");
    private static final Pattern YEARBOX_CHECKSUM_PATTERN = Pattern.compile("^\\d{4}:[0-9A-Fa-f]{64,66}$");
    private static final Pattern FLEXIBLE_YEARBOX_CHECKSUM_PATTERN = Pattern.compile("^(\\d{4})([:/])([0-9A-Fa-f]{64}|[0-9A-Fa-f]{66})$");

    private static String canonicalizeChecksum(String checksum) {
        if (checksum == null) {
            return null;
        }
        String trimmed = checksum.trim();
        if (trimmed.isEmpty()) {
            return null;
        }
        if (CHECKSUM_66_PATTERN.matcher(trimmed).matches()) {
            return trimmed;
        }
        if (CHECKSUM_64_PATTERN.matcher(trimmed).matches()) {
            return trimmed + "00";
        }
        return null;
    }

    public static boolean isValid66Checksum(String checksum) {
        return checksum != null && CHECKSUM_66_PATTERN.matcher(checksum).matches();
    }

    public static boolean isValidYearBoxFormat(String yearBox) {
        return yearBox != null && YEARBOX_PATTERN.matcher(yearBox).matches();
    }

    public static boolean isValidYearBoxAndChecksumFormat(String yearBoxAndChecksum) {
        return yearBoxAndChecksum != null && YEARBOX_CHECKSUM_PATTERN.matcher(yearBoxAndChecksum).matches();
    }

    public boolean isValid(String checksum) {
        return checksum != null && (CHECKSUM_64_PATTERN.matcher(checksum).matches() || CHECKSUM_66_PATTERN.matcher(checksum).matches());
    }

    public boolean isValid66(String checksum) {
        return checksum != null && CHECKSUM_66_PATTERN.matcher(checksum).matches();
    }

    public boolean isValid64(String checksum) {
        return checksum != null && CHECKSUM_64_PATTERN.matcher(checksum).matches();
    }

    public boolean isValidYearBox(String yearBox) {
        return yearBox != null && YEARBOX_PATTERN.matcher(yearBox).matches();
    }

    public boolean isValidYearBoxAndChecksum(String yearBoxAndChecksum) {
        return yearBoxAndChecksum != null && YEARBOX_CHECKSUM_PATTERN.matcher(yearBoxAndChecksum).matches();
    }

    public static String normalizeYearBoxAndChecksum(String yearBoxAndChecksum) {
        if (yearBoxAndChecksum == null) {
            return null;
        }
        String trimmed = yearBoxAndChecksum.trim();
        if (trimmed.isEmpty()) {
            return null;
        }
        String sanitized = trimmed.replace('/', ':');
        Matcher matcher = FLEXIBLE_YEARBOX_CHECKSUM_PATTERN.matcher(sanitized);
        if (!matcher.matches()) {
            return null;
        }
        String canonicalChecksum = ChecksumValidator.canonicalizeChecksum(matcher.group(3));
        if (canonicalChecksum == null) {
            return null;
        }
        String canonical = matcher.group(1) + ":" + canonicalChecksum;
        return YEARBOX_CHECKSUM_PATTERN.matcher(canonical).matches() ? canonical : null;
    }

    public void validate(String checksum) {
        if (!this.isValid(checksum)) {
            throw new IllegalArgumentException("Invalid checksum format: " + checksum);
        }
    }

    public void validate66(String checksum) {
        if (!this.isValid66(checksum)) {
            throw new IllegalArgumentException("Invalid 66-character checksum format: " + checksum);
        }
    }

    public void validateYearBox(String yearBox) {
        if (!this.isValidYearBox(yearBox)) {
            throw new IllegalArgumentException("Invalid yearBox format: " + yearBox);
        }
    }

    public void validateYearBoxAndChecksum(String yearBoxAndChecksum) {
        if (!this.isValidYearBoxAndChecksum(yearBoxAndChecksum)) {
            throw new IllegalArgumentException("Invalid yearBox:checksum format (expected YYYY:<64-66 hex chars>): " + yearBoxAndChecksum);
        }
    }
}

