/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.journal;

import de.lwsystems.mailarchive.archive.box.IBoxGenerator;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.journal.JournalFileLocator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultJournalFileLocator
implements JournalFileLocator {
    private static final Logger LOGGER = LogManager.getLogger(DefaultJournalFileLocator.class);

    @Override
    public Stream<Path> findJournalFiles(IContainer container, String startChecksum) throws IOException {
        List<Path> yearDirs;
        IBoxGenerator boxGenerator = container.getBoxGenerator();
        if (boxGenerator == null) {
            LOGGER.warn("No box generator found for container: {}", (Object)container.getIdentifier());
            return Stream.empty();
        }
        String baseDirectory = boxGenerator.getBoxGeneratorConfig().getDirectory();
        if (baseDirectory == null || baseDirectory.isEmpty()) {
            LOGGER.warn("No base directory configured for container: {}", (Object)container.getIdentifier());
            return Stream.empty();
        }
        Path containerPath = Paths.get(baseDirectory, new String[0]).normalize().toAbsolutePath();
        if (!Files.exists(containerPath, new LinkOption[0]) || !Files.isDirectory(containerPath, new LinkOption[0])) {
            LOGGER.warn("Container directory does not exist or is not a directory: {}", (Object)containerPath);
            return Stream.empty();
        }
        Integer startYear = this.extractYearFromChecksum(startChecksum);
        LOGGER.debug("Searching for journal files in: {} (startYear: {})", (Object)containerPath, (Object)startYear);
        try (Stream<Path> listing = Files.list(containerPath);){
            yearDirs = listing.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(p -> p.getFileName().toString().matches("^\\d{4}$")).filter(p -> {
                if (startYear == null) {
                    return true;
                }
                int year = Integer.parseInt(p.getFileName().toString());
                return year <= startYear;
            }).sorted(Comparator.comparing(p -> Integer.parseInt(p.getFileName().toString()))).toList();
        }
        ArrayList journalFiles = new ArrayList();
        for (Path yearDir : yearDirs) {
            Path journalDir = yearDir.resolve("journal");
            if (!Files.isDirectory(journalDir, new LinkOption[0])) continue;
            Stream<Path> journalListing = Files.list(journalDir);
            try {
                journalListing.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(this::isJournalFile).sorted(Comparator.comparing(p -> p.getFileName().toString())).forEach(journalFiles::add);
            }
            finally {
                if (journalListing == null) continue;
                journalListing.close();
            }
        }
        return journalFiles.stream();
    }

    private boolean isJournalFile(Path path) {
        String fileName = path.getFileName().toString().toLowerCase();
        return fileName.endsWith(".journal") || fileName.endsWith(".journal.gz") || fileName.contains("journal");
    }

    Integer extractYearFromChecksum(String checksum) {
        String[] parts;
        if (checksum == null || checksum.isBlank()) {
            return null;
        }
        if (checksum.contains(":") && (parts = checksum.split(":", 2)).length >= 1 && parts[0].matches("^\\d{4}$")) {
            try {
                return Integer.parseInt(parts[0]);
            }
            catch (NumberFormatException e) {
                LOGGER.debug("Could not parse year from checksum: {}", (Object)checksum);
                return null;
            }
        }
        return null;
    }

    boolean shouldIncludePath(Path path, Path basePath, Integer startYear) {
        if (startYear == null) {
            return true;
        }
        Path relativePath = basePath.relativize(path);
        for (Path component : relativePath) {
            String name = component.toString();
            if (!name.matches("^\\d{4}$")) continue;
            try {
                int year = Integer.parseInt(name);
                return year <= startYear;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return true;
    }
}

