/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.journal;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;

public class FilterCriteria {
    private final String startChecksum;
    private final String endChecksum;
    private final Set<String> excludedChecksums;
    private final int offset;
    private final int limit;

    public FilterCriteria(String startChecksum, String endChecksum, Set<String> excludedChecksums, int offset, int limit) {
        this.startChecksum = startChecksum;
        this.endChecksum = endChecksum;
        this.excludedChecksums = excludedChecksums != null ? excludedChecksums : Collections.emptySet();
        this.offset = offset;
        this.limit = limit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<String> getStartChecksum() {
        return Optional.ofNullable(this.startChecksum);
    }

    public Optional<String> getEndChecksum() {
        return Optional.ofNullable(this.endChecksum);
    }

    public Set<String> getExcludedChecksums() {
        return this.excludedChecksums;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public static class Builder {
        private String startChecksum;
        private String endChecksum;
        private Set<String> excludedChecksums;
        private int offset = 0;
        private int limit = 1000;

        public Builder startChecksum(String checksum) {
            this.startChecksum = checksum;
            return this;
        }

        public Builder endChecksum(String checksum) {
            this.endChecksum = checksum;
            return this;
        }

        public Builder excludedChecksums(Set<String> checksums) {
            this.excludedChecksums = checksums;
            return this;
        }

        public Builder offset(int offset) {
            this.offset = offset;
            return this;
        }

        public Builder limit(int limit) {
            this.limit = limit;
            return this;
        }

        public FilterCriteria build() {
            return new FilterCriteria(this.startChecksum, this.endChecksum, this.excludedChecksums, this.offset, this.limit);
        }
    }
}

