/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.journal;

import de.lwsystems.mailarchive.journal.ChecksumEntry;
import de.lwsystems.mailarchive.journal.ProcessingError;
import java.util.Collections;
import java.util.List;

public record JournalChecksumResult(List<ChecksumEntry> checksums, int totalCount, boolean truncated, String message, long processingTimeMillis, List<ProcessingError> errors) {
    public JournalChecksumResult(List<ChecksumEntry> checksums, int totalCount, boolean truncated, String message, long processingTimeMillis, List<ProcessingError> errors) {
        this.checksums = checksums != null ? Collections.unmodifiableList(checksums) : Collections.emptyList();
        this.totalCount = totalCount;
        this.truncated = truncated;
        this.message = message;
        this.processingTimeMillis = processingTimeMillis;
        this.errors = errors != null ? Collections.unmodifiableList(errors) : Collections.emptyList();
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public static class Builder {
        private List<ChecksumEntry> checksums;
        private int totalCount;
        private boolean truncated;
        private String message;
        private long processingTimeMillis;
        private List<ProcessingError> errors;

        public Builder checksums(List<ChecksumEntry> checksums) {
            this.checksums = checksums;
            return this;
        }

        public Builder totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public Builder truncated(boolean truncated) {
            this.truncated = truncated;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder processingTimeMillis(long processingTimeMillis) {
            this.processingTimeMillis = processingTimeMillis;
            return this;
        }

        public Builder errors(List<ProcessingError> errors) {
            this.errors = errors;
            return this;
        }

        public JournalChecksumResult build() {
            return new JournalChecksumResult(this.checksums, this.totalCount, this.truncated, this.message, this.processingTimeMillis, this.errors);
        }
    }
}

