/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.journal;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum JournalOperation {
    ARCHIVED("archived"),
    REPO_DELETE("repodelete"),
    DUPLICATE("duplicate"),
    INDEX_DELETE("indexdelete"),
    START("start"),
    BOX_CLOSED("box closed"),
    UNKNOWN("unknown");

    private static final Pattern CHECKSUM_PATTERN;
    private static final String SUCCESS_TOKEN = "(success)";
    private final String keyword;

    private JournalOperation(String keyword) {
        this.keyword = keyword.toLowerCase(Locale.ROOT);
    }

    public static JournalOperation fromLine(String line) {
        if (line == null) {
            return UNKNOWN;
        }
        String lowerLine = line.toLowerCase(Locale.ROOT);
        if (lowerLine.contains(JournalOperation.ARCHIVED.keyword) && (!lowerLine.contains(SUCCESS_TOKEN) || JournalOperation.archivedBetweenSuccessAndChecksum(lowerLine))) {
            return ARCHIVED;
        }
        for (JournalOperation op : JournalOperation.values()) {
            if (op == ARCHIVED || !lowerLine.contains(op.keyword)) continue;
            return op;
        }
        return UNKNOWN;
    }

    private static boolean archivedBetweenSuccessAndChecksum(String lowerLine) {
        int successIndex = lowerLine.indexOf(SUCCESS_TOKEN);
        if (successIndex < 0) {
            return false;
        }
        int boundaryIndex = JournalOperation.findBoundaryIndex(lowerLine, successIndex + SUCCESS_TOKEN.length());
        if (boundaryIndex < 0) {
            return false;
        }
        int searchIndex = successIndex + SUCCESS_TOKEN.length();
        int archivedIndex;
        while ((archivedIndex = lowerLine.indexOf(JournalOperation.ARCHIVED.keyword, searchIndex)) >= 0) {
            if (archivedIndex >= boundaryIndex) {
                return false;
            }
            if (JournalOperation.isWholeWord(lowerLine, archivedIndex, JournalOperation.ARCHIVED.keyword.length())) {
                return true;
            }
            searchIndex = archivedIndex + JournalOperation.ARCHIVED.keyword.length();
        }
        return false;
    }

    private static int findBoundaryIndex(String lowerLine, int fromIndex) {
        int checksumIndex = JournalOperation.findFirstChecksumIndex(lowerLine, fromIndex);
        int quoteIndex = lowerLine.indexOf(34, fromIndex);
        if (checksumIndex >= 0 && quoteIndex >= 0) {
            return Math.min(checksumIndex, quoteIndex);
        }
        if (checksumIndex >= 0) {
            return checksumIndex;
        }
        return quoteIndex;
    }

    private static int findFirstChecksumIndex(String lowerLine, int fromIndex) {
        Matcher matcher = CHECKSUM_PATTERN.matcher(lowerLine);
        if (matcher.find(fromIndex)) {
            return matcher.start();
        }
        return -1;
    }

    private static boolean isWholeWord(String lowerLine, int start, int length) {
        int before = start - 1;
        int after = start + length;
        boolean leftOk = before < 0 || !Character.isLetter(lowerLine.charAt(before));
        boolean rightOk = after >= lowerLine.length() || !Character.isLetter(lowerLine.charAt(after));
        return leftOk && rightOk;
    }

    public static JournalOperation fromStatus(String status) {
        if (status == null) {
            return UNKNOWN;
        }
        return switch (status.toUpperCase(Locale.ROOT).replace(" ", "_")) {
            case "ARCHIVED" -> ARCHIVED;
            case "REPODELETE" -> REPO_DELETE;
            case "DUPLICATE" -> DUPLICATE;
            case "INDEXDELETE" -> INDEX_DELETE;
            case "START" -> START;
            case "BOX_CLOSED" -> BOX_CLOSED;
            default -> UNKNOWN;
        };
    }

    public String getKeyword() {
        return this.keyword;
    }

    static {
        CHECKSUM_PATTERN = Pattern.compile("[0-9a-f]{66}");
    }
}

