/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.journal;

import java.time.Duration;
import java.util.Objects;

public class JournalServiceConfig {
    private final int maxResponseSize;
    private final Duration timeout;
    private final int defaultPageSize;
    private final int maxPageSize;
    private final int threadPoolSize;
    private final String allowedBasePath;

    private JournalServiceConfig(Builder builder) {
        this.maxResponseSize = builder.maxResponseSize;
        this.timeout = builder.timeout;
        this.defaultPageSize = builder.defaultPageSize;
        this.maxPageSize = builder.maxPageSize;
        this.threadPoolSize = builder.threadPoolSize;
        this.allowedBasePath = builder.allowedBasePath;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getMaxResponseSize() {
        return this.maxResponseSize;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public int getDefaultPageSize() {
        return this.defaultPageSize;
    }

    public int getMaxPageSize() {
        return this.maxPageSize;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public String getAllowedBasePath() {
        return this.allowedBasePath;
    }

    public static class Builder {
        private int maxResponseSize = 10000;
        private Duration timeout = Duration.ofSeconds(30L);
        private int defaultPageSize = 1000;
        private int maxPageSize = 10000;
        private int threadPoolSize = Runtime.getRuntime().availableProcessors();
        private String allowedBasePath = System.getProperty("user.home");

        public Builder maxResponseSize(int size) {
            if (size <= 0) {
                throw new IllegalArgumentException("Max response size must be positive");
            }
            this.maxResponseSize = size;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = Objects.requireNonNull(timeout, "Timeout cannot be null");
            return this;
        }

        public Builder defaultPageSize(int size) {
            if (size <= 0) {
                throw new IllegalArgumentException("Page size must be positive");
            }
            this.defaultPageSize = size;
            return this;
        }

        public Builder maxPageSize(int size) {
            if (size <= 0) {
                throw new IllegalArgumentException("Max page size must be positive");
            }
            this.maxPageSize = size;
            return this;
        }

        public Builder threadPoolSize(int size) {
            if (size <= 0) {
                throw new IllegalArgumentException("Thread pool size must be positive");
            }
            this.threadPoolSize = size;
            return this;
        }

        public Builder allowedBasePath(String path) {
            this.allowedBasePath = Objects.requireNonNull(path, "Allowed base path cannot be null");
            return this;
        }

        public JournalServiceConfig build() {
            return new JournalServiceConfig(this);
        }
    }
}

