/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.mailservice;

import com.google.common.eventbus.EventBus;
import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.config.DeleteMailCondition;
import de.lwsystems.mailarchive.event.DeliveredEvent;
import de.lwsystems.mailarchive.maildocument.ArchivedMailDocument;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maildocument.MailDocumentListener;
import de.lwsystems.mailarchive.maildocument.RemovedMailDocument;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.maillistener.IMailListener;
import de.lwsystems.mailarchive.maillistener.NonFailingArchivingException;
import de.lwsystems.mailarchive.parser.IFileParser;
import de.lwsystems.mailarchive.parser.ParserException;
import de.lwsystems.mailarchive.utils.FileNameSuffix;
import de.lwsystems.mailarchive.utils.FileNameUtils;
import de.lwsystems.mailarchive.utils.FileOperationUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.mail.MessagingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class BennoFileProcessor {
    private static final Logger LOGGER = LogManager.getLogger(BennoFileProcessor.class);
    private final File directory;
    private final IFileParser fileParser;
    private final List<IMailListener> listeners;
    private final EventBus eventBus;
    private boolean destroyed;
    private DeleteMailCondition deleteMailCondition;

    public BennoFileProcessor(File directory, IFileParser fileParser, List<IMailListener> listeners, EventBus eventBus) {
        this.directory = directory;
        this.fileParser = fileParser;
        this.listeners = listeners;
        this.eventBus = eventBus;
        this.deleteMailCondition = DeleteMailCondition.ALL;
    }

    public BennoFileProcessor(File directory, IFileParser fileParser, List<IMailListener> listeners, EventBus eventBus, DeleteMailCondition deleteMailCondition) {
        this(directory, fileParser, listeners, eventBus);
        this.deleteMailCondition = deleteMailCondition;
    }

    public void processFile(Path filename) {
        Date date = new Date();
        final long ts = new Timestamp(date.getTime()).getTime();
        Path file = null;
        try {
            final Path processedFile = file = FileNameUtils.renameFile(filename, FileNameSuffix.PROCESSING_SUFFIX, this.directory);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Read file " + String.valueOf(file.toAbsolutePath()));
            }
            MailDocument document = this.fileParser.parseFile(processedFile);
            document.addMailDocumentListener(new MailDocumentListener(){

                @Override
                public void processingCompleted() {
                    block5: {
                        try {
                            if (!FileOperationUtils.isFileSuffixSet(processedFile, FileNameSuffix.KEP_SUFFIX)) {
                                if (BennoFileProcessor.this.deleteMailCondition.equals((Object)DeleteMailCondition.ALL) || BennoFileProcessor.this.deleteMailCondition.equals((Object)DeleteMailCondition.ASSIGNED)) {
                                    Files.delete(processedFile);
                                } else {
                                    FileOperationUtils.changeFileSuffix(processedFile, FileNameSuffix.KEP_SUFFIX);
                                    LOGGER.warn("Mail {} is not deleted and has been renamed with the suffix kep. If you do not want this behavior, remove the delete -d parameter from startup or change the value to ALL.", (Object)processedFile.getFileName());
                                }
                            }
                        }
                        catch (IOException e) {
                            if (BennoFileProcessor.this.deleteMailCondition.equals((Object)DeleteMailCondition.ASSIGNED)) break block5;
                            e.printStackTrace();
                            LOGGER.warn("Problem deleting .prc email file " + String.valueOf(processedFile.toAbsolutePath()), (Throwable)e);
                        }
                    }
                }

                @Override
                public void mailIsNotArchived() {
                    block3: {
                        try {
                            if (BennoFileProcessor.this.deleteMailCondition.equals((Object)DeleteMailCondition.ASSIGNED) || BennoFileProcessor.this.deleteMailCondition.equals((Object)DeleteMailCondition.NEVER)) {
                                FileOperationUtils.changeFileSuffix(processedFile, FileNameSuffix.KEP_SUFFIX);
                                LOGGER.warn("Mail {} is not deleted and has been renamed with the suffix kep. If you do not want this behavior, remove the Delete parameter or set it to ALL.", (Object)processedFile);
                            }
                        }
                        catch (IOException e) {
                            if (BennoFileProcessor.this.deleteMailCondition.equals((Object)DeleteMailCondition.ASSIGNED)) break block3;
                            e.printStackTrace();
                            LOGGER.warn("Problem copying .prc email file " + String.valueOf(processedFile.toAbsolutePath()), (Throwable)e);
                        }
                    }
                }

                @Override
                public void removingCompleted() {
                }

                @Override
                public void processingError(Exception ex) {
                    block2: {
                        LOGGER.error("Error processing file \"" + String.valueOf(processedFile.toAbsolutePath()) + "\"", (Throwable)ex);
                        try {
                            String incomingFileName = processedFile.toString();
                            String errorFileName = incomingFileName.substring(0, incomingFileName.length() - 4);
                            Files.move(processedFile, Paths.get(errorFileName + "-" + ts + FileNameSuffix.ERROR_SUFFIX.getValue(), new String[0]), new CopyOption[0]);
                        }
                        catch (IOException e) {
                            if (BennoFileProcessor.this.deleteMailCondition.equals((Object)DeleteMailCondition.ASSIGNED)) break block2;
                            e.printStackTrace();
                            LOGGER.warn("Problem moving to .err email file " + String.valueOf(processedFile.toAbsolutePath()));
                        }
                    }
                }
            });
            if (this.deliverMail(document)) {
                document.archivingSuccessful();
            } else {
                LOGGER.warn("Problem archiving email file " + String.valueOf(file.toAbsolutePath()));
                String incomingFileName = file.toString();
                String errorFileName = incomingFileName.substring(0, incomingFileName.length() - 4);
                Files.move(file, Paths.get(errorFileName + "-" + ts + FileNameSuffix.ERROR_SUFFIX.getValue(), new String[0]), new CopyOption[0]);
            }
        }
        catch (FileNotFoundException ex) {
            LOGGER.error("Listed file not found (had been removed before it could be read", (Throwable)ex);
        }
        catch (FileSystemException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
        catch (ParserException ex) {
            LOGGER.error("Error parsing file \"" + String.valueOf(file.toAbsolutePath()) + "\"", (Throwable)ex);
            try {
                String incomingFileName = file.toString();
                String errorFileName = incomingFileName.substring(0, incomingFileName.length() - 4);
                Files.move(file, Paths.get(errorFileName + "-" + ts + FileNameSuffix.ERROR_SUFFIX.getValue(), new String[0]), new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                LOGGER.warn("Problem moving to .err email file " + String.valueOf(file.toAbsolutePath()), (Throwable)e);
            }
        }
        catch (IOException ex) {
            LOGGER.error("File could not be moved", (Throwable)ex);
        }
    }

    public boolean removeDocument(MailDocument document) throws IOException, MessagingException, ParserException {
        document.addMailDocumentListener(new MailDocumentListener(){

            @Override
            public void processingCompleted() {
            }

            @Override
            public void mailIsNotArchived() {
            }

            @Override
            public void removingCompleted() {
            }

            @Override
            public void processingError(Exception ex) {
            }
        });
        this.deliverRemoveDocument(document);
        return true;
    }

    protected boolean deliverRemoveDocument(MailDocument document) {
        boolean successful = true;
        if (!this.isDestroyed()) {
            for (IMailListener listener : this.listeners) {
                try {
                    RemovedMailDocument removedMailDocument = listener.removeDocument(document);
                }
                catch (ArchiveException e) {
                    e.printStackTrace();
                }
                catch (FailedArchivingException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (NonFailingArchivingException e) {
                    e.printStackTrace();
                }
            }
            if (this.eventBus != null) {
                this.eventBus.post((Object)new DeliveredEvent(document));
            }
        } else {
            successful = false;
        }
        return successful;
    }

    protected boolean deliverMail(MailDocument mail) {
        boolean successful = true;
        if (!this.isDestroyed()) {
            for (IMailListener listener : this.listeners) {
                try {
                    ArchivedMailDocument archivedMailDocument = listener.addDocument(mail);
                }
                catch (NonFailingArchivingException ex) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Email \"" + mail.toString() + "\" was not archived by \"" + String.valueOf(listener) + "\"", (Throwable)ex);
                    }
                    mail.backupUnassignedMail();
                }
                catch (FailedArchivingException ex) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Problem archiving email " + String.valueOf(ex));
                    }
                    successful = false;
                }
            }
            if (this.eventBus != null) {
                this.eventBus.post((Object)new DeliveredEvent(mail));
            }
        } else {
            successful = false;
        }
        return successful;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void setDestroyed(boolean destroyed) {
        this.destroyed = destroyed;
    }

    public void addRemoveRepoJournalEntry(RemovedMailDocument document) {
        if (!this.isDestroyed()) {
            for (IMailListener listener : this.listeners) {
                try {
                    listener.addRemoveRepoJournalEntry(document);
                }
                catch (FailedArchivingException | NonFailingArchivingException e) {
                    e.printStackTrace();
                }
            }
            if (this.eventBus != null) {
                this.eventBus.post((Object)new DeliveredEvent(document.getDocument()));
            }
        }
    }
}

