/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.utils;

import de.lwsystems.mailarchive.utils.FileNameSuffix;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileOperationUtils {
    private static final Logger LOGGER = LogManager.getLogger(FileOperationUtils.class);

    public static boolean isFileSuffixSet(Path filePath, FileNameSuffix suffix) {
        if (filePath == null || suffix == null) {
            return false;
        }
        String fileName = filePath.getFileName().toString();
        return fileName.endsWith(suffix.getValue());
    }

    public static boolean isFileSuffixSet(Path filePath, FileNameSuffix ... suffixes) {
        if (filePath == null || suffixes == null || suffixes.length == 0) {
            return false;
        }
        String fileName = filePath.getFileName().toString();
        for (FileNameSuffix suffix : suffixes) {
            if (suffix == null || !fileName.endsWith(suffix.getValue())) continue;
            return true;
        }
        return false;
    }

    public static void changeFileSuffix(Path processedFile, FileNameSuffix fileNameSuffix) throws IOException {
        try {
            String incomingFileName = processedFile.toString();
            String moveFilename = incomingFileName.substring(0, incomingFileName.length() - 4);
            Path targetPath = Paths.get(moveFilename + fileNameSuffix.getValue(), new String[0]);
            Files.move(processedFile, targetPath, new CopyOption[0]);
        }
        catch (IOException e) {
            LOGGER.warn("Problem moving .prc email file to {} {}: {} ", (Object)fileNameSuffix, (Object)processedFile.toAbsolutePath(), (Object)e.getMessage());
            throw e;
        }
    }
}

