/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.utils;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.utils.BennoBuildTime;
import de.lwsystems.mailarchive.utils.BennoVersion;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InitizalizationMail {
    private static final Logger LOGGER = LogManager.getLogger(InitizalizationMail.class);

    public static void createInitializationMailMessage(Benno benno) {
        try {
            Message initializationMail = InitizalizationMail.createInitialiationMailHeader();
            initializationMail.setContent((Multipart)new MimeMultipart(new BodyPart[]{InitizalizationMail.createInitializationMailBody()}));
            InitizalizationMail.saveInitializationMailInInbox(initializationMail, benno);
        }
        catch (MessagingException me) {
            LOGGER.error((Object)me);
        }
    }

    private static Message createInitialiationMailHeader() throws MessagingException {
        MimeMessage initializationMail = new MimeMessage((Session)null);
        String fromHeader = "benno-archive@sys.benno-mailarchiv.de";
        String toHeader = "benno-system@sys.benno-mailarchiv.de";
        String subjectHeader = "Benno MailArchiv Installation";
        String bennoSystemRecipientHeaderName = "X-BENNO-System-Recipient";
        String bennoSystemRecipientHeaderValue = "<benno-system@sys.benno-mailarchiv.de>";
        String bennoRestVersionHeaderName = "X-BENNO-Rest-Version";
        String bennoRestVersionHeaderValue = BennoBuildTime.restBuildTime();
        String bennoCoreVersionHeaderName = "X-BENNO-Core-Version";
        String bennoCoreVersionHeaderValue = BennoBuildTime.coreBuildTime();
        initializationMail.setFrom((Address)new InternetAddress("benno-archive@sys.benno-mailarchiv.de"));
        initializationMail.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress("benno-system@sys.benno-mailarchiv.de"));
        initializationMail.setSubject("Benno MailArchiv Installation");
        initializationMail.setHeader("X-BENNO-System-Recipient", "<benno-system@sys.benno-mailarchiv.de>");
        initializationMail.setHeader("X-BENNO-Rest-Version", bennoRestVersionHeaderValue);
        initializationMail.setHeader("X-BENNO-Core-Version", bennoCoreVersionHeaderValue);
        initializationMail.setSentDate(new Date());
        return initializationMail;
    }

    private static MimeBodyPart createInitializationMailBody() throws MessagingException {
        MimeBodyPart body = new MimeBodyPart();
        body.setText("bennorest: " + BennoVersion.restVersion() + " (" + BennoBuildTime.restBuildTime() + ")\nbennocore: " + BennoVersion.coreVersion() + " (" + BennoBuildTime.coreBuildTime() + ")");
        return body;
    }

    private static void saveInitializationMailInInbox(Message licenseMail, Benno benno) {
        String inboxPath = benno.getConfig().getArchiveGenerator().getArchives().get((int)0).services.get((int)0).directory.toString();
        String initializationMailName = "initialization.eml";
        File outputFile = new File(inboxPath + "/initialization.eml");
        try (FileOutputStream out = new FileOutputStream(outputFile);){
            licenseMail.writeTo((OutputStream)out);
        }
        catch (IOException | MessagingException ex) {
            LOGGER.error((Object)ex);
        }
    }
}

