<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:variable name="smallcase" select="'abcdefghijklmnopqrstuvwxyz'" />
    <xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'" />

    <xsl:template match="@* | node()">
        <xsl:copy>
            <xsl:apply-templates select="@* | node()"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="/boxstate[not(@configVersion) or @configVersion = '1']">
        <boxstate configVersion="2">
            <xsl:apply-templates select="box" mode="migrate"/>
        </boxstate>
    </xsl:template>

    <xsl:template match="/benno[not(@configVersion) or @configVersion = '1']">
        <xsl:copy>
            <xsl:attribute name="configVersion">2</xsl:attribute>
            <xsl:apply-templates select="@* | node()" mode="migrate"/>
        </xsl:copy>
    </xsl:template>

    <!-- rename simplecontainer elements to container -->
    <xsl:template match="simplecontainer" mode="migrate">
        <container>
            <xsl:apply-templates select="@*|node()" mode="migrate"/>
        </container>
    </xsl:template>

    <xsl:template match="redcontainer" mode="migrate">
        <redcontainer>
            <xsl:apply-templates select="@*|node()" mode="migrate"/>
        </redcontainer>
    </xsl:template>


    <!-- rename containerarchive elements to archive -->
    <xsl:template match="containerarchive" mode="migrate">
        <archive>
            <xsl:apply-templates select="@*|node()" mode="migrate"/>
        </archive>
    </xsl:template>

    <xsl:template match="@* | node()" mode="migrate">
        <xsl:copy>
            <xsl:apply-templates select="@* | node()" mode="migrate"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="*['fsbox' = substring(local-name(), string-length(local-name()) - string-length('fsbox') + 1)]"
                  mode="migrate">
        <xsl:element name="boxgenerator">
            <xsl:attribute name="rotation">
                <xsl:value-of select="translate(substring-before(local-name(), 'fsbox'), $smallcase, $uppercase)"/>
            </xsl:attribute>
            <xsl:apply-templates select="fshexbennobox/directory"/>
            <boxtemplate>
                <xsl:apply-templates mode="migrate"
                                     select="fshexbennobox/*['fsjournal' = substring(local-name(), string-length(local-name()) - string-length('fsjournal') + 1)]"/>
                <xsl:apply-templates select="fshexbennobox/compression"/>
                <storage driver="fs">
                    <xsl:apply-templates select="fshexbennobox/subdirs"/>
                    <xsl:apply-templates select="fshexbennobox/dirlength"/>
                </storage>
            </boxtemplate>
        </xsl:element>
    </xsl:template>

    <xsl:template
            match="*['fsjournal' = substring(local-name(), string-length(local-name()) - string-length('fsjournal') + 1)]"
            mode="migrate">
        <xsl:element name="journal">
            <xsl:attribute name="rotation">
                <xsl:value-of select="translate(substring-before(local-name(.), 'fsjournal'), $smallcase, $uppercase)"/>
            </xsl:attribute>
        </xsl:element>
    </xsl:template>

    <!-- migrate simplearchive to (container)archive -->
    <xsl:template match="simplearchive" mode="migrate">
        <archive>
            <identifier><xsl:value-of select="identifier"/> wrapper</identifier>
            <xsl:apply-templates select="conditions" mode="migrate"/>
            <xsl:apply-templates select="readonly" mode="migrate"/>
            <xsl:apply-templates select="directorywatcher" mode="migrate"/>
            <configuredcontainers>
                <container>
                    <xsl:apply-templates select="identifier" mode="migrate"/>
                    <xsl:apply-templates select="readonly" mode="migrate"/>
                    <xsl:apply-templates select="luceneindex" mode="migrate"/>
                    <xsl:apply-templates select="*['fsbox' = substring(local-name(), string-length(local-name()) - string-length('fsbox') + 1)]" mode="migrate"/>
                </container>
            </configuredcontainers>
        </archive>
    </xsl:template>

    <!-- migrate repoarchive to (container)archive -->
    <xsl:template match="repoarchive" mode="migrate">
        <archive>
            <identifier><xsl:value-of select="identifier"/> wrapper</identifier>
            <xsl:apply-templates select="conditions" mode="migrate"/>
            <xsl:apply-templates select="readonly" mode="migrate"/>
            <xsl:apply-templates select="directorywatcher" mode="migrate"/>
            <configuredcontainers>
                <container>
                    <xsl:apply-templates select="identifier" mode="migrate"/>
                    <xsl:apply-templates select="readonly" mode="migrate"/>
                    <xsl:apply-templates select="*['fsbox' = substring(local-name(), string-length(local-name()) - string-length('fsbox') + 1)]" mode="migrate"/>
                </container>
            </configuredcontainers>
        </archive>
    </xsl:template>

    <!-- fshexbennobox in boxstate -->
    <xsl:template match="fshexbennobox" mode="migrate">
        <config>
            <id><xsl:value-of select="id"/></id>
            <xsl:apply-templates mode="migrate"
                                 select="*['fsjournal' = substring(local-name(), string-length(local-name()) - string-length('fsjournal') + 1)]"/>
            <xsl:apply-templates select="compression"/>
            <storage driver="fs">
                <xsl:apply-templates select="subdirs"/>
                <xsl:apply-templates select="dirlength"/>
            </storage>
        </config>
    </xsl:template>

</xsl:stylesheet>