/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.AbstractArchiveGenerator;
import de.lwsystems.mailarchive.archive.ArchiveNotFoundException;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.authentication.IBennoUserIdentity;
import de.lwsystems.mailarchive.authentication.IBennoUserIdentityService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractMapArchiveGenerator
extends AbstractArchiveGenerator {
    private static final Logger LOGGER = Logger.getLogger(AbstractMapArchiveGenerator.class);
    private final transient Map<String, IArchive> archives;
    private String authArchive = null;

    protected final Map<String, IArchive> getArchiveMap() {
        return this.archives;
    }

    @Override
    public final Map<String, IArchive> getArchiveMapFK() {
        return this.archives;
    }

    @Override
    public final Iterable<IArchive> getArchives() {
        return this.archives.values();
    }

    public AbstractMapArchiveGenerator(Benno benno) {
        super(benno);
        this.archives = new HashMap<String, IArchive>();
    }

    public AbstractMapArchiveGenerator(Benno benno, Map<String, IArchive> map, String authArchive) {
        super(benno);
        this.archives = map;
        if (authArchive != null && this.archives.containsKey(authArchive)) {
            this.authArchive = authArchive;
        }
    }

    @Override
    public final IArchive getArchive(String name) throws ArchiveNotFoundException {
        IArchive archive = this.archives.get(name);
        if (archive == null) {
            throw new ArchiveNotFoundException(name);
        }
        return archive;
    }

    protected final void addArchive(String identifier, IArchive archive) {
        this.archives.put(identifier, archive);
    }

    @Override
    public String getIdentifier() {
        StringBuilder archives = null;
        for (IArchive archive : this.getArchives()) {
            if (archives == null) {
                archives = new StringBuilder(32);
            } else {
                archives.append(", ");
            }
            archives.append(archive.getIdentifier());
        }
        return archives == null ? "no archive" : archives.toString();
    }

    public String getAuthArchive() {
        return this.authArchive;
    }

    public void setAuthArchive(String authArchive) {
        this.authArchive = authArchive;
    }

    @Override
    public IBennoUserIdentity loadUser(IBennoUserIdentityService identityService, String username) {
        IBennoUserIdentity userIdentity = null;
        if (this.authArchive == null) {
            IArchive archive = null;
            try {
                archive = this.getArchive(this.authArchive);
            }
            catch (ArchiveNotFoundException archiveNotFoundException) {
                // empty catch block
            }
            if (archive == null) {
                LOGGER.info((Object)("Archive \"" + this.authArchive + "\" not found for authenitfication."));
            } else {
                userIdentity = archive.loadUser(identityService, "", username);
            }
        } else {
            int atPos = username.indexOf("@");
            if (atPos < 0) {
                LOGGER.info((Object)("No archive divider \"@\" found in username, username \"" + username + "\" invalid"));
            } else {
                String archiveName = username.substring(atPos + 1);
                String archiveUsername = username.substring(0, atPos);
                IArchive archive = null;
                try {
                    archive = this.getArchive(archiveName);
                }
                catch (ArchiveNotFoundException archiveNotFoundException) {
                    // empty catch block
                }
                if (archive == null) {
                    LOGGER.info((Object)("Archive \"" + archiveName + "\" not found for authenitfication."));
                } else {
                    userIdentity = archive.loadUser(identityService, "@" + archiveName, archiveUsername);
                }
            }
        }
        return userIdentity;
    }

    @Override
    public Collection<IBennoUserIdentity> loadUsers(IBennoUserIdentityService identityService) {
        ArrayList<IBennoUserIdentity> useridentities = new ArrayList<IBennoUserIdentity>();
        for (String archiveName : this.getArchiveMap().keySet()) {
            IArchive archive = null;
            try {
                archive = this.getArchive(archiveName);
            }
            catch (ArchiveNotFoundException archiveNotFoundException) {
                // empty catch block
            }
            if (archive == null) continue;
            useridentities.addAll(archive.loadUsers(identityService, this.authArchive));
        }
        return useridentities;
    }

    public Map<String, IArchive> getArchives_FK() {
        return this.archives;
    }
}

