/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.AbstractSingleIndexArchive;
import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.box.BoxGeneratorFactory;
import de.lwsystems.mailarchive.archive.box.IBoxGenerator;
import de.lwsystems.mailarchive.config.ISimpleArchiveConfig;
import de.lwsystems.mailarchive.maildocument.DocumentId;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maillistener.DocumentAlreadyArchivedException;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.maillistener.NonFailingArchivingException;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.lucene.store.Directory;

public class SimpleArchive
extends AbstractSingleIndexArchive {
    private static final Logger LOGGER = Logger.getLogger(SimpleArchive.class);
    private IBoxGenerator boxGenerator = null;

    public SimpleArchive(Benno benno, ISimpleArchiveConfig config, boolean readOnly) throws ArchiveException, IOException {
        super(benno, config, config.getIndex(), config.getIdentifier(), readOnly);
        this.boxGenerator = BoxGeneratorFactory.createBoxGenerator(this, config.getBoxGenerator(), readOnly);
    }

    @Override
    public DocumentId addDocument(MailDocument document) throws FailedArchivingException, NonFailingArchivingException {
        DocumentId documentId = null;
        if (this.doesMatch(document.getMetaData())) {
            try {
                documentId = this.boxGenerator.addDocument(document);
            }
            catch (DocumentAlreadyArchivedException e) {
                LOGGER.warn((Object)("Document is already archived and will only be reindexed: " + documentId.getFullDocumentId()));
            }
            this.getIndex().addDocument(documentId);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Store email as " + documentId.getFullDocumentId()));
            }
        } else {
            throw new NonFailingArchivingException(document, "Document does not match archiving criteria");
        }
        return documentId;
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String toString() {
        return this.getIdentifier() + " SimpleArchive";
    }

    @Override
    public Directory getIndexPath() {
        throw new UnsupportedOperationException("Not supported here.");
    }

    @Override
    public void shutdown() {
        this.boxGenerator.shutdown();
    }
}

