/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.box;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.RuntimeArchiveException;
import de.lwsystems.mailarchive.archive.box.AbstractBox;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.IBoxHolder;
import de.lwsystems.mailarchive.archive.journal.IJournal;
import de.lwsystems.mailarchive.archive.journal.JournalFactory;
import de.lwsystems.mailarchive.config.FSJournalConfig;
import de.lwsystems.mailarchive.config.IFSBoxConfig;
import de.lwsystems.mailarchive.maildocument.MailMetaData;
import java.io.File;

public abstract class AbstractFSBox
extends AbstractBox {
    private final int dirLength;
    private final IJournal journal;
    private final boolean readOnly;
    private final File repositoryDirectory;
    private final int subdirs;

    private AbstractFSBox(IBoxHolder boxHolder, String identifier, File repositoryDirectory, FSJournalConfig journal, int dirLength, int subdirs, IBox.CompressionType compression, boolean readOnly) throws ArchiveException {
        super(boxHolder, identifier, compression);
        this.repositoryDirectory = repositoryDirectory.getAbsoluteFile();
        this.dirLength = dirLength;
        this.subdirs = subdirs;
        this.readOnly = readOnly;
        this.journal = readOnly ? null : JournalFactory.createFSJournal(this, journal, new File(repositoryDirectory + File.separator + "journal"), readOnly);
    }

    public AbstractFSBox(IBoxHolder boxHolder, IFSBoxConfig config, boolean readOnly) throws ArchiveException {
        this(boxHolder, config.getIdentifier(), new File(config.getDirectory()), config.getJournal(), config.getDirLength(), config.getSubdirs(), config.getCompression(), readOnly);
    }

    public AbstractFSBox(IBoxHolder boxHolder, IFSBoxConfig config, String identifier, boolean readOnly) throws ArchiveException {
        this(boxHolder, identifier, new File(config.getDirectory() + File.separator + identifier), config.getJournal(), config.getDirLength(), config.getSubdirs(), config.getCompression(), readOnly);
    }

    public String getFileBaseForId(MailMetaData data) {
        StringBuffer fileBase = new StringBuffer(this.getRepositoryDirectory().getAbsolutePath());
        String idName = this.getDocumentName(data);
        for (int i = 0; i < this.subdirs; ++i) {
            fileBase.append(File.separator).append(idName.substring(0, this.dirLength));
            idName = idName.substring(this.dirLength);
        }
        fileBase.append(File.separator).append(idName);
        return fileBase.toString();
    }

    public String getFileBaseForId(String identifier, String id) {
        StringBuffer fileBase = new StringBuffer(this.getRepositoryDirectory().getParent() + "/" + identifier + "/");
        String idName = id;
        for (int i = 0; i < this.subdirs; ++i) {
            fileBase.append(File.separator).append(idName.substring(0, this.dirLength));
            idName = idName.substring(this.dirLength);
        }
        fileBase.append(File.separator).append(idName);
        return fileBase.toString();
    }

    @Override
    public IJournal getJournal() {
        return this.journal;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public abstract String getDocumentName(MailMetaData var1);

    protected File getRepositoryDirectory() {
        return this.repositoryDirectory;
    }

    @Override
    public String closeBox() {
        return this.journal.closeJournal();
    }

    @Override
    public boolean exists() {
        return this.getRepositoryDirectory().exists();
    }

    protected void checkDirectory() {
        File repositoryDirectory = this.getRepositoryDirectory();
        String absolutePath = repositoryDirectory.getAbsolutePath();
        if (!repositoryDirectory.exists()) {
            if (this.isReadOnly()) {
                throw new RuntimeArchiveException(this.getBoxHolder(), "Repositorydirectory \"" + absolutePath + "\" does not exist. (" + this.getIdentifier() + ")");
            }
            if (!repositoryDirectory.mkdirs()) {
                throw new RuntimeArchiveException(this.getBoxHolder(), "Repositorydirectory \"" + absolutePath + "\" canot be created. (" + this.getIdentifier() + ")");
            }
            if (!repositoryDirectory.exists()) {
                throw new RuntimeArchiveException(this.getBoxHolder(), "Repositorydirectory \"" + absolutePath + "\" canot be created. (" + this.getIdentifier() + ")");
            }
        }
        if (!repositoryDirectory.isDirectory()) {
            throw new RuntimeArchiveException(this.getBoxHolder(), "Repositorydirectory \"" + absolutePath + "\" is not a directory. (" + this.getIdentifier() + ")");
        }
        if (!this.isReadOnly() && !repositoryDirectory.canWrite()) {
            throw new RuntimeArchiveException(this.getBoxHolder(), "Repositorydirectory \"" + absolutePath + "\" is not a writeable. (" + this.getIdentifier() + ")");
        }
    }
}

