/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.box;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.box.AbstractBoxGenerator;
import de.lwsystems.mailarchive.archive.box.BoxGeneratorState;
import de.lwsystems.mailarchive.archive.box.FSHexBennoBox;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.IBoxHolder;
import de.lwsystems.mailarchive.archive.journal.ClosedBoxJournalEntry;
import de.lwsystems.mailarchive.config.AbstractFSBoxConfig;
import de.lwsystems.mailarchive.config.IBoxConfig;
import de.lwsystems.mailarchive.config.IFSBoxConfig;
import de.lwsystems.mailarchive.config.IFSBoxGeneratorConfig;
import de.lwsystems.mailarchive.maildocument.DocumentId;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maillistener.DocumentAlreadyArchivedException;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.maillistener.NonFailingArchivingException;
import de.lwsystems.mailarchive.utils.Clock;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.DurationFieldType;
import org.joda.time.LocalDate;

public abstract class AbstractMultiFSBoxGenerator
extends AbstractBoxGenerator {
    private static final Logger LOGGER = Logger.getLogger(AbstractMultiFSBoxGenerator.class);
    private final boolean readOnly;
    private final int periodMultiplier;
    private final DurationFieldType periodType;
    private final DateFormat dateFormat;

    public AbstractMultiFSBoxGenerator(IBoxHolder boxHolder, IFSBoxGeneratorConfig config, DurationFieldType periodType, int periodMultiplier, DateFormat dateFormat, boolean readOnly) throws ArchiveException {
        super(boxHolder, AbstractMultiFSBoxGenerator.getBoxGeneratorState(config));
        this.periodType = periodType;
        this.periodMultiplier = periodMultiplier;
        this.readOnly = readOnly;
        this.dateFormat = dateFormat;
    }

    private static BoxGeneratorState getBoxGeneratorState(IFSBoxGeneratorConfig config) {
        BoxGeneratorState state = null;
        File boxStateFile = new File(config.getBox().getDirectory() + File.separator + "boxstate.xml");
        if (boxStateFile.exists() && boxStateFile.canRead()) {
            try {
                state = (BoxGeneratorState)BoxGeneratorState.getPersister().read(BoxGeneratorState.class, boxStateFile);
            }
            catch (Exception ex) {
                LOGGER.error((Object)("Error reading boxstate in \"" + boxStateFile.getAbsolutePath() + "\""), (Throwable)ex);
            }
        }
        if (state == null) {
            state = new BoxGeneratorState(config.getBox());
        }
        return state;
    }

    protected void saveState() throws ArchiveException {
        BoxGeneratorState state = this.getState();
        if (state != null) {
            AbstractFSBoxConfig config = (AbstractFSBoxConfig)state.getConfig();
            File directory = new File(config.directory);
            if (!directory.exists()) {
                if (this.readOnly) {
                    throw new ArchiveException(this.getBoxHolder(), "Repositorydirectory \"" + directory.getAbsolutePath() + "\" does not exist.");
                }
                if (!directory.mkdirs()) {
                    throw new ArchiveException(this.getBoxHolder(), "Repositorydirectory \"" + directory.getAbsolutePath() + "\" canot be created.");
                }
                if (!directory.exists()) {
                    throw new ArchiveException(this.getBoxHolder(), "Repositorydirectory \"" + directory.getAbsolutePath() + "\" canot be created.");
                }
            }
            if (!directory.isDirectory()) {
                throw new ArchiveException(this.getBoxHolder(), "Repositorydirectory \"" + directory.getAbsolutePath() + "\" is not a directory.");
            }
            if (!this.readOnly && !directory.canWrite()) {
                throw new ArchiveException(this.getBoxHolder(), "Repositorydirectory \"" + directory.getAbsolutePath() + "\" is not a writeable.");
            }
            File boxStateFile = new File(config.directory + File.separator + "boxstate.xml");
            try {
                BoxGeneratorState.getPersister().write((Object)state, boxStateFile);
            }
            catch (Exception ex) {
                LOGGER.fatal((Object)("Error writing boxstate to \"" + boxStateFile.getAbsolutePath() + "\""), (Throwable)ex);
            }
        }
    }

    protected String getBoxNameForDate(Date date) {
        return this.dateFormat.format(date);
    }

    protected String getActualBoxName() {
        return this.getBoxNameForDate(Clock.getProvider().newDate());
    }

    private synchronized IBox getCurrentBox() throws ArchiveException {
        IBox box = null;
        if (!this.readOnly) {
            String boxName = this.getActualBoxName();
            if (boxName.equals(this.getState().getActualBoxName())) {
                box = this.getState().getActualBox();
            } else {
                IBox oldBox = this.getState().getActualBox();
                String oldHash = null;
                if (oldBox != null) {
                    oldHash = oldBox.closeBox();
                    box = this.getBoxByName(boxName);
                    box.getJournal().addEntry(new ClosedBoxJournalEntry(oldBox.getIdentifier(), oldHash));
                } else {
                    box = this.getBoxByName(boxName);
                }
                this.getState().setActualBox(box);
                this.saveState();
            }
        }
        return box;
    }

    private IBox getBoxByName(String boxName) throws ArchiveException {
        return this.getBox((AbstractFSBoxConfig)this.getState().getConfig(), this.getBoxHolder(), boxName, this.isReadOnly());
    }

    public IBox getBox(IBoxConfig boxConfig, IBoxHolder boxHolder, String identifier, boolean readOnly) throws ArchiveException {
        FSHexBennoBox box = null;
        if (boxConfig instanceof IFSBoxConfig) {
            IFSBoxConfig fsBoxConfig = (IFSBoxConfig)boxConfig;
            switch (fsBoxConfig.getFSBoxType()) {
                case HEX_BENNO: {
                    box = new FSHexBennoBox(boxHolder, fsBoxConfig, identifier, readOnly);
                    break;
                }
            }
        }
        return box;
    }

    @Override
    public DocumentId addDocument(MailDocument document) throws FailedArchivingException, NonFailingArchivingException, DocumentAlreadyArchivedException {
        DocumentId docid = null;
        if (this.isReadOnly()) {
            throw new FailedArchivingException(document, "BoxGenerator is readonly");
        }
        DocumentId existingDocument = this.getDocument(document);
        if (existingDocument != null) {
            throw new DocumentAlreadyArchivedException(document);
        }
        try {
            IBox box = this.getCurrentBox();
            docid = box.addDocument(document);
            docid.setInternalId(box.getIdentifier());
        }
        catch (ArchiveException ex) {
            throw new FailedArchivingException(document, ex);
        }
        return docid;
    }

    @Override
    public DocumentId getDocument(MailDocument document) {
        DocumentId docid = null;
        Iterator<String> boxNameIterator = this.getBoxNameIterator();
        while (boxNameIterator.hasNext()) {
            try {
                IBox box = this.getBoxByName(boxNameIterator.next());
                if (box.exists() || box.getIdentifier().equals(this.getCurrentBox().getIdentifier())) {
                    docid = box.getDocument(document);
                    if (docid == null) continue;
                    docid.setInternalId(box.getIdentifier());
                    return docid;
                }
                break;
            }
            catch (ArchiveException e) {
            }
        }
        return null;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected Iterator<String> getBoxNameIterator() {
        DateTime date = Clock.getProvider().newJodaDateTime();
        date.withFieldAdded(this.periodType, -1);
        return new Iterator<String>(){
            private LocalDate current;

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public String next() {
                this.current = this.current == null ? Clock.getProvider().newLocalDate() : this.current.withFieldAdded(AbstractMultiFSBoxGenerator.this.periodType, AbstractMultiFSBoxGenerator.this.periodMultiplier * -1);
                return AbstractMultiFSBoxGenerator.this.getBoxNameForDate(this.current.toDate());
            }
        };
    }
}

