/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.box;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.box.AbstractBoxGenerator;
import de.lwsystems.mailarchive.archive.box.BoxGeneratorState;
import de.lwsystems.mailarchive.archive.box.FSHexBennoBox;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.IBoxHolder;
import de.lwsystems.mailarchive.config.IFSBoxConfig;
import de.lwsystems.mailarchive.config.ISingleFSBoxGeneratorConfig;
import de.lwsystems.mailarchive.maildocument.DocumentId;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maillistener.DocumentAlreadyArchivedException;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.maillistener.NonFailingArchivingException;
import org.apache.log4j.Logger;

public abstract class AbstractSingleBoxGenerator
extends AbstractBoxGenerator {
    private final Logger logger = Logger.getLogger(AbstractSingleBoxGenerator.class);
    private final IBox box;

    public AbstractSingleBoxGenerator(IBoxHolder boxHolder, ISingleFSBoxGeneratorConfig config, boolean readOnly) throws ArchiveException {
        super(boxHolder, new BoxGeneratorState(config.getBox()));
        this.box = this.getBox(config.getBox(), boxHolder, readOnly);
    }

    private IBox getBox(IFSBoxConfig boxConfig, IBoxHolder boxHolder, boolean readOnly) throws ArchiveException {
        FSHexBennoBox box = new FSHexBennoBox(boxHolder, boxConfig, readOnly);
        this.getState().setActualBox(box);
        return box;
    }

    @Override
    public DocumentId addDocument(MailDocument document) throws FailedArchivingException, NonFailingArchivingException, DocumentAlreadyArchivedException {
        return this.box.addDocument(document);
    }

    @Override
    public DocumentId getDocument(MailDocument document) {
        return this.box.getDocument(document);
    }
}

