/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.box;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.box.AbstractBoxGenerator;
import de.lwsystems.mailarchive.archive.box.IBoxGenerator;
import de.lwsystems.mailarchive.archive.box.MinutelyFSBoxGenerator;
import de.lwsystems.mailarchive.archive.box.MonthlyFSBoxGenerator;
import de.lwsystems.mailarchive.archive.box.QuarterlyFSBoxGenerator;
import de.lwsystems.mailarchive.archive.box.SingleFSBoxGenerator;
import de.lwsystems.mailarchive.archive.box.WeeklyFSBoxGenerator;
import de.lwsystems.mailarchive.archive.box.YearlyFSBoxGenerator;
import de.lwsystems.mailarchive.config.IBoxGeneratorConfig;
import de.lwsystems.mailarchive.config.IFSBoxGeneratorConfig;
import de.lwsystems.mailarchive.config.ISingleFSBoxGeneratorConfig;

public class BoxGeneratorFactory {
    public static IBoxGenerator createBoxGenerator(IArchive simpleArchive, IBoxGeneratorConfig boxGeneratorConfig, boolean readOnly) throws ArchiveException {
        AbstractBoxGenerator boxGenerator = null;
        switch (boxGeneratorConfig.getType()) {
            case MINUTELYFSBOX: {
                boxGenerator = new MinutelyFSBoxGenerator(simpleArchive, (IFSBoxGeneratorConfig)boxGeneratorConfig, readOnly);
                break;
            }
            case MONTHLYFSBOX: {
                boxGenerator = new MonthlyFSBoxGenerator(simpleArchive, (IFSBoxGeneratorConfig)boxGeneratorConfig, readOnly);
                break;
            }
            case QUARTERLYFSBOX: {
                boxGenerator = new QuarterlyFSBoxGenerator(simpleArchive, (IFSBoxGeneratorConfig)boxGeneratorConfig, readOnly);
                break;
            }
            case SINGLEFSBOX: {
                boxGenerator = new SingleFSBoxGenerator(simpleArchive, (ISingleFSBoxGeneratorConfig)boxGeneratorConfig, readOnly);
                break;
            }
            case WEEKLYFSBOX: {
                boxGenerator = new WeeklyFSBoxGenerator(simpleArchive, (IFSBoxGeneratorConfig)boxGeneratorConfig, readOnly);
                break;
            }
            case YEARLYFSBOX: {
                boxGenerator = new YearlyFSBoxGenerator(simpleArchive, (IFSBoxGeneratorConfig)boxGeneratorConfig, readOnly);
                break;
            }
            default: {
                throw new RuntimeException("bad config");
            }
        }
        return boxGenerator;
    }
}

