/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.container;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.AbstractArchive;
import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.container.IContainerGenerator;
import de.lwsystems.mailarchive.config.IContainerArchiveConfig;
import de.lwsystems.mailarchive.maildocument.DocumentId;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.maillistener.NonFailingArchivingException;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.lucene.store.Directory;

public class ContainerArchive
extends AbstractArchive {
    private final Logger LOGGER = Logger.getLogger(ContainerArchive.class);
    private final IContainerGenerator containerGenerator;

    public ContainerArchive(Benno benno, IContainerArchiveConfig config, boolean readOnly) throws ArchiveException, IOException {
        super(benno, config, config.getIdentifier(), readOnly);
        this.containerGenerator = config.getContainergenerator().getContainerGenerator(benno, this, readOnly);
    }

    @Override
    public DocumentId addDocument(MailDocument document) throws NonFailingArchivingException, FailedArchivingException {
        DocumentId documentId = null;
        if (!this.doesMatch(document.getMetaData())) {
            if (this.LOGGER.isInfoEnabled()) {
                this.LOGGER.info((Object)("Email \"" + document.toString() + "\" does not match criteria of container\"" + this.containerGenerator.getArchive().getIdentifier() + "\""));
            }
            throw new NonFailingArchivingException(document, "Document does not match archiving criteria");
        }
        documentId = this.containerGenerator.addDocument(document);
        return documentId;
    }

    @Override
    public boolean optimizeIndex() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String toString() {
        return this.getIdentifier() + " ContainerArchive";
    }

    @Override
    public Directory getIndexPath() {
        throw new UnsupportedOperationException("Not supported here!");
    }

    @Override
    public IContainerGenerator getContainerGenerator() {
        return this.containerGenerator;
    }

    @Override
    public void shutdown() {
        this.containerGenerator.shutdown();
    }
}

