/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.authentication;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.box.IBoxHolder;
import de.lwsystems.mailarchive.authentication.AbstractAuthenticator;
import de.lwsystems.mailarchive.authentication.AuthXml;
import de.lwsystems.mailarchive.authentication.AuthXmlUser;
import de.lwsystems.mailarchive.authentication.IBennoUserIdentity;
import de.lwsystems.mailarchive.authentication.IBennoUserIdentityService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.log4j.Logger;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.strategy.TreeStrategy;

public class FSXmlAuthenticator
extends AbstractAuthenticator {
    private static final Logger LOGGER = Logger.getLogger(FSXmlAuthenticator.class);
    private final IArchive archive;
    private final File file;
    private AuthXml authXml = null;

    private AuthXml getAuthXml() {
        if (this.authXml == null) {
            this.loadAuthXml();
        }
        return this.authXml;
    }

    public FSXmlAuthenticator(IArchive archive, File file) throws ArchiveException {
        this.archive = archive;
        this.file = file;
        if (this.file == null) {
            throw new ArchiveException((IBoxHolder)archive, "Authentication file must not be null");
        }
        if (!this.file.exists()) {
            throw new ArchiveException((IBoxHolder)archive, "Authentication file \"" + this.file.getAbsolutePath() + "\" does not exist");
        }
        if (!this.file.canRead()) {
            throw new ArchiveException((IBoxHolder)archive, "Authentication file \"" + this.file.getAbsolutePath() + "\" does not exist");
        }
    }

    private static Persister getPersister() {
        return new Persister((Strategy)new TreeStrategy("type", "count"));
    }

    private AuthXml loadAuthXml() {
        if (this.file == null) {
            LOGGER.error((Object)"Authenticationfile must not be null");
        } else {
            try {
                this.authXml = (AuthXml)FSXmlAuthenticator.getPersister().read(AuthXml.class, this.file);
            }
            catch (Exception ex) {
                LOGGER.error((Object)("Error reading Authenticationfile \"" + this.file.getAbsolutePath() + "\""), (Throwable)ex);
            }
        }
        return this.authXml;
    }

    private void saveAuthXml() {
        if (this.file == null) {
            LOGGER.error((Object)"Authenticationfile must not be null");
        } else {
            try {
                FSXmlAuthenticator.getPersister().write((Object)this.authXml, this.file);
            }
            catch (Exception ex) {
                LOGGER.error((Object)("Error reading Authenticationfile \"" + this.file.getAbsolutePath() + "\""), (Throwable)ex);
            }
        }
    }

    @Override
    public IBennoUserIdentity loadUser(IArchive archive, IBennoUserIdentityService identityService, String postfix, String username) {
        IBennoUserIdentity userIdentity = null;
        AuthXmlUser user = this.loadAuthXml().getUser(username);
        if (user != null) {
            String fullUsername = username;
            if (postfix != null) {
                fullUsername = username + "@" + postfix;
            }
            ArrayList<String> roleCollection = new ArrayList<String>();
            user.addRoles(roleCollection);
            String[] roles = roleCollection.toArray(new String[roleCollection.size()]);
            userIdentity = identityService.newUserIdentity(archive, fullUsername, user.password, roles);
        }
        return userIdentity;
    }

    public IBennoUserIdentity getUser(IArchive archive, IBennoUserIdentityService identityService, String postfix, String username) {
        IBennoUserIdentity userIdentity = null;
        AuthXmlUser user = this.getAuthXml().getUser(username);
        if (user != null) {
            String fullUsername = username;
            if (postfix != null) {
                fullUsername = username + "@" + postfix;
            }
            ArrayList<String> roleCollection = new ArrayList<String>();
            user.addRoles(roleCollection);
            String[] roles = roleCollection.toArray(new String[roleCollection.size()]);
            userIdentity = identityService.newUserIdentity(archive, fullUsername, user.password, roles);
        }
        return userIdentity;
    }

    @Override
    public Collection<IBennoUserIdentity> loadUsers(IArchive archive, IBennoUserIdentityService identityService, String postix) {
        ArrayList<IBennoUserIdentity> userIdentities = new ArrayList<IBennoUserIdentity>();
        Set<String> users = this.loadAuthXml().getUsers();
        for (String user : users) {
            userIdentities.add(this.getUser(archive, identityService, postix, user));
        }
        return userIdentities;
    }
}

