/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.condition;

import de.lwsystems.mailarchive.condition.AbstractCondition;
import de.lwsystems.mailarchive.condition.ConditionConfigType;
import de.lwsystems.mailarchive.condition.ConditionFactory;
import de.lwsystems.mailarchive.config.ConditionNotConfig;
import de.lwsystems.mailarchive.config.IConditionConfig;
import de.lwsystems.mailarchive.maildocument.MailMetaData;

@ConditionConfigType(value=IConditionConfig.ConditionType.NOT)
public class NotCondition
extends AbstractCondition {
    private final AbstractCondition condition;

    public NotCondition(ConditionNotConfig config) {
        this.condition = ConditionFactory.createCondition(config.getCondition());
    }

    @Override
    public boolean matches(MailMetaData metaData) {
        return !this.condition.matches(metaData);
    }

    @Override
    public boolean isAlwaysTrue() {
        return this.condition.isAlwaysFalse();
    }

    @Override
    public boolean isAlwaysFalse() {
        return this.condition.isAlwaysTrue();
    }
}

