/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.utils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.simpleframework.xml.transform.Transform;

public class BennoXmlDateTransform
implements Transform<Date> {
    private final ArrayList<DateFormat> legacyFormats = new ArrayList();
    private final DateTimeFormatter isoFormat;

    public BennoXmlDateTransform() {
        this.legacyFormats.add(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S z", Locale.ENGLISH));
        this.legacyFormats.add(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S z", Locale.GERMAN));
        this.isoFormat = ISODateTimeFormat.basicDateTime();
    }

    public Date read(String value) throws Exception {
        for (DateFormat format : this.legacyFormats) {
            try {
                return format.parse(value);
            }
            catch (ParseException parseException) {
            }
        }
        return this.isoFormat.parseDateTime(value).toDate();
    }

    public String write(Date value) throws Exception {
        return this.isoFormat.print((ReadableInstant)new DateTime((Object)value));
    }
}

