/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.utils;

import java.io.IOException;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.xml.sax.SAXException;

public class TikaUtils {
    public static Parser getTikaParser(ParseContext context) {
        Parser parser = (Parser)context.get(AutoDetectParser.class);
        if (parser == null) {
            parser = (Parser)context.get(Parser.class);
        }
        if (parser == null) {
            TikaConfig tikaConfig = (TikaConfig)context.get(TikaConfig.class);
            if (tikaConfig == null) {
                try {
                    tikaConfig = new TikaConfig(TikaUtils.class.getResourceAsStream("/benno-tika-config.xml"));
                }
                catch (IOException | TikaException | SAXException e) {
                    throw new RuntimeException(e);
                }
            }
            parser = new AutoDetectParser(new Parser[]{tikaConfig.getParser()});
        }
        return parser;
    }
}

