/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive;

import de.lwsystems.mailarchive.utils.License;
import de.lwsystems.mailarchive.utils.LicenseException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class LicenseCheck {
    public static void main(String[] args) throws ParseException {
        String licenseFile = "";
        String hostInfo = "";
        if (args.length == 0) {
            System.err.print(LicenseCheck.getHelp());
            Runtime.getRuntime().exit(1);
        }
        Options options = new Options();
        options.addOption("h", false, "print help");
        options.addOption("f", true, "license file");
        options.addOption("i", true, "host info string");
        options.addOption("d", true, "date to check (YYYY-MM-DD)");
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        if (cmd.hasOption("h")) {
            System.out.print(LicenseCheck.getHelp());
        }
        if (cmd.hasOption("f")) {
            licenseFile = cmd.getOptionValue("f");
        } else {
            System.err.print("Lizenz-Datei wurde nicht angegeben.\n");
            System.err.print(LicenseCheck.getHelp());
            Runtime.getRuntime().exit(2);
        }
        if (cmd.hasOption("i")) {
            hostInfo = cmd.getOptionValue("i").trim();
        } else {
            System.err.print("Host-Info String wurde nicht angegeben.\n");
            System.err.print(LicenseCheck.getHelp());
            Runtime.getRuntime().exit(2);
        }
        if (cmd.hasOption("d")) {
            String checkDate = cmd.getOptionValue("d").trim();
        } else {
            System.err.print("Pr\u00fcf-Datum wurde nicht angegeben.\n");
            System.err.print(LicenseCheck.getHelp());
            Runtime.getRuntime().exit(2);
        }
        System.out.println("Pr\u00fcfe Lizenz: " + licenseFile);
        try {
            boolean retval;
            License bennoLicense = new License(licenseFile);
            if (bennoLicense.getType().equals("Evaluation")) {
                System.out.println("Lizenztyp: Evaluation");
                try {
                    retval = bennoLicense.checkExpire();
                }
                catch (LicenseException ex) {
                    System.out.println("FEHLER - Lizenz ist abgelaufen: " + ex.getMessage());
                }
            } else {
                try {
                    retval = bennoLicense.checkBuild();
                }
                catch (LicenseException ex) {
                    System.out.println("FEHLER - Lizenz ist f\u00fcr die installierte Version ung\u00fcltig: " + ex.getMessage());
                }
            }
            try {
                retval = bennoLicense.checkValid(hostInfo);
            }
            catch (LicenseException ex) {
                System.out.println("FEHLER - Lizenz ist f\u00fcr diesen Host ung\u00fcltig: " + ex.getMessage());
            }
        }
        catch (Exception ex) {
            System.out.println("FEHLER - Kann Lizenz nicht pr\u00fcfen: " + ex.getMessage());
        }
    }

    public static String getHelp() {
        String help = "Aufruf: benno-licensecheck -f <license file> -i <host-info> -d <YYYY-MM-DD>\n";
        return help;
    }
}

