/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.box;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.box.BoxState;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.IBoxHolder;
import de.lwsystems.mailarchive.config.IBoxConfig;
import de.lwsystems.mailarchive.config.xml.FSHexBennoBoxConfig;
import de.lwsystems.mailarchive.utils.BennoXmlDateTransform;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.ElementUnion;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.filter.Filter;
import org.simpleframework.xml.filter.PlatformFilter;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.strategy.TreeStrategy;
import org.simpleframework.xml.transform.Matcher;
import org.simpleframework.xml.transform.Transform;

@Root(name="boxstate")
public class BoxGeneratorState {
    private String actualBoxName = null;
    private IBox actualBox = null;
    @ElementMap(entry="box", key="identifier", attribute=true, inline=true, required=false)
    private HashMap<String, BoxState> boxes;
    @ElementUnion(value={@Element(name="fshexbennobox", type=FSHexBennoBoxConfig.class)})
    private IBoxConfig config;
    private boolean readOnly = true;

    public static Persister getPersister() {
        return new Persister((Strategy)new TreeStrategy("type", "count"), (Filter)new PlatformFilter(new HashMap()), new Matcher(){

            public Transform match(Class type) throws Exception {
                if (type == Date.class) {
                    return new BennoXmlDateTransform();
                }
                return null;
            }
        });
    }

    public BoxGeneratorState() {
    }

    public BoxGeneratorState(IBoxConfig config) {
        this.config = config;
        this.boxes = new HashMap();
    }

    public void checkBoxes(IBoxHolder holder) throws ArchiveException {
        this.actualBoxName = null;
        for (Map.Entry<String, BoxState> entry : this.boxes.entrySet()) {
            if (entry.getValue().state != IBox.BOXSTATE.OPEN) continue;
            if (this.getActualBoxName() == null) {
                this.actualBoxName = entry.getKey();
                this.setActualBox(entry.getValue().getBox(holder, this.isReadOnly()));
                continue;
            }
            throw new ArchiveException(holder, "Boxgenerator with two open boxes \"" + this.getActualBoxName() + "\" and \"" + entry.getKey() + "\"");
        }
    }

    public HashMap<String, BoxState> getBoxes() {
        return this.boxes;
    }

    public IBoxConfig getConfig() {
        return this.config;
    }

    public String getActualBoxName() {
        return this.actualBoxName;
    }

    public IBox getActualBox() {
        return this.actualBox;
    }

    public void setActualBox(IBox actualBox) {
        if (this.actualBox != null) {
            this.boxes.get((Object)this.actualBoxName).state = IBox.BOXSTATE.CLOSED;
        }
        this.actualBox = actualBox;
        this.actualBoxName = actualBox.getIdentifier();
        this.boxes.put(this.actualBoxName, new BoxState(actualBox.getConfig()));
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }
}

