/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.box;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.box.AbstractMultiFSBoxGenerator;
import de.lwsystems.mailarchive.archive.box.IBoxHolder;
import de.lwsystems.mailarchive.config.IFSBoxGeneratorConfig;
import de.lwsystems.mailarchive.utils.Clock;
import de.lwsystems.mailarchive.utils.DateUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.joda.time.DurationFieldType;

public class QuarterlyFSBoxGenerator
extends AbstractMultiFSBoxGenerator {
    private static final DateFormat DATEFORMAT = new SimpleDateFormat("yyyy", Locale.ROOT);

    public QuarterlyFSBoxGenerator(IBoxHolder boxHolder, IFSBoxGeneratorConfig config, boolean readOnly) throws ArchiveException {
        super(boxHolder, config, DurationFieldType.months(), 3, DATEFORMAT, readOnly);
    }

    @Override
    protected String getBoxNameForDate(Date date) {
        String dateFormatted = super.getBoxNameForDate(date);
        Calendar calendar = Clock.getProvider().getCalendarInstance(Locale.ROOT);
        calendar.setTime(date);
        return DateUtil.getQuartalString(dateFormatted, calendar);
    }
}

